/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

final class SourceFormatter
implements TemplateDirectiveModel {
    SourceFormatter() {
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (!params.isEmpty()) {
            throw new TemplateModelException("SourceFormatter doesn't allow parameters.");
        }
        if (loopVars.length != 0) {
            throw new TemplateModelException("SourceFormatter doesn't allow loop variables.");
        }
        if (body == null) {
            throw new RuntimeException("SourceFormatter missing body");
        }
        body.render((Writer)new CppSourceFormatterWriter(env.getOut()));
    }

    private static class CppSourceFormatterWriter
    extends Writer {
        private final Writer out;
        private State state = State.GOT_CR;
        private String indent = "";

        CppSourceFormatterWriter(Writer out) {
            this.out = out;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                this.addChar(cbuf[off + i]);
            }
        }

        private void addChar(char c) throws IOException {
            switch (this.state) {
                case GOT_CR: 
                case GOT2_CR: {
                    if (c == '\n') {
                        if (this.state == State.GOT_CR) {
                            this.out.write(c);
                        }
                        this.state = State.GOT2_CR;
                        return;
                    }
                    if (Character.isWhitespace(c)) {
                        return;
                    }
                    if (c == '}') {
                        this.indent = this.indent.substring(3);
                    }
                    this.out.write(this.indent);
                    this.out.write(c);
                    if (c == '{') {
                        this.indent = this.indent + "   ";
                    }
                    this.state = State.FORMATTING;
                    break;
                }
                case FORMATTING: {
                    if (c == '{') {
                        this.indent = this.indent + "   ";
                    }
                    if (c == '}') {
                        this.indent = this.indent.substring(3);
                    }
                    if (c == '\n') {
                        this.state = State.GOT_CR;
                    }
                    this.out.write(c);
                    break;
                }
            }
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        static enum State {
            GOT_CR,
            GOT2_CR,
            FORMATTING;

        }
    }
}

