/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp;

import com.github.loicoudot.java4cpp.Analyzer;
import com.github.loicoudot.java4cpp.Context;
import com.github.loicoudot.java4cpp.Java4Cpp;
import com.github.loicoudot.java4cpp.configuration.ClassMapping;
import com.github.loicoudot.java4cpp.model.ClassModel;

public class SuperclassAnalyzer
extends Analyzer {
    public SuperclassAnalyzer(Context context) {
        super(context);
    }

    @Override
    public void fill(ClassModel classModel) {
        Class<?> clazz = classModel.getType().getClazz();
        if (clazz.getSuperclass() != null && this.exportSuperClass(clazz)) {
            classModel.getContent().setSuperclass(this.context.getClassModel(clazz.getSuperclass()));
        }
    }

    boolean exportSuperClass(Class<?> clazz) {
        ClassMapping mapping = this.mappings.get(clazz);
        Java4Cpp annotation = clazz.getAnnotation(Java4Cpp.class);
        return mapping != null ? mapping.isSuperclass() : annotation != null && annotation.superclass();
    }
}

