/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp;

import com.github.loicoudot.java4cpp.Context;
import com.github.loicoudot.java4cpp.Java4CppType;
import com.github.loicoudot.java4cpp.ThreadTemplateLoader;
import com.github.loicoudot.java4cpp.TypeTemplates;
import com.github.loicoudot.java4cpp.Utils;
import com.github.loicoudot.java4cpp.configuration.Function;
import com.github.loicoudot.java4cpp.configuration.Templates;
import com.github.loicoudot.java4cpp.configuration.TypeTemplate;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXB;

final class TemplateManager {
    private final Context context;
    private final Templates templates = new Templates();
    private final Configuration configuration = new Configuration();
    private final List<Template> globalTemplates = Utils.newArrayList();
    private final Map<Class<?>, TypeTemplates> typeCache = Utils.newHashMap();

    public TemplateManager(Context context) {
        this.context = context;
        try {
            TemplateLoader[] loaders = new TemplateLoader[]{new FileTemplateLoader(), new ThreadTemplateLoader()};
            this.configuration.setTemplateLoader((TemplateLoader)new MultiTemplateLoader(loaders));
            this.configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            this.configuration.setDefaultEncoding("ISO-8859-1");
            this.configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            this.configuration.setIncompatibleImprovements(new Version(2, 3, 20));
            this.configuration.setLocalizedLookup(false);
        }
        catch (IOException e) {
            throw new RuntimeException("FreeMarker initialisation error " + e.getMessage());
        }
    }

    public void addTemplates(Templates other) {
        this.templates.getGlobalTemplates().addAll(other.getGlobalTemplates());
        this.templates.getCopyFiles().addAll(other.getCopyFiles());
        if (other.getDatatypes().getFallback() != null) {
            this.templates.getDatatypes().setFallback(other.getDatatypes().getFallback());
        }
        if (other.getDatatypes().getArray() != null) {
            this.templates.getDatatypes().setArray(other.getDatatypes().getArray());
        }
        if (other.getDatatypes().getEnumeration() != null) {
            this.templates.getDatatypes().setEnumeration(other.getDatatypes().getEnumeration());
        }
        this.templates.getDatatypes().getTemplates().removeAll(other.getDatatypes().getTemplates());
        this.templates.getDatatypes().getTemplates().addAll(other.getDatatypes().getTemplates());
    }

    public void start() {
        try {
            this.addTemplatesFromSettings();
            for (String templateName : this.templates.getGlobalTemplates()) {
                this.globalTemplates.add(this.configuration.getTemplate(templateName));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read templates " + e.getMessage());
        }
    }

    private void addTemplatesFromSettings() {
        if (!Utils.isNullOrEmpty(this.context.getSettings().getTemplatesFile())) {
            for (String name : this.context.getSettings().getTemplatesFile().split(";")) {
                try {
                    InputStream is = Utils.getFileOrResource(name);
                    Templates template = (Templates)JAXB.unmarshal((InputStream)is, Templates.class);
                    is.close();
                    this.addTemplates(template);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read templates: " + e.getMessage());
                }
            }
        }
    }

    public void copyFiles() {
        try {
            for (String file : this.templates.getCopyFiles()) {
                this.context.getFileManager().copyFile(file);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to copy file " + e.getMessage());
        }
    }

    public void processSourceTemplates(Java4CppType type, Map<String, Object> dataModel) {
        this.processTemplates(dataModel, this.getTypeTemplates(type.getRawClass()).getSourceTemplates());
    }

    public void processGlobalTemplates(Map<String, Object> dataModel) {
        this.processTemplates(dataModel, this.globalTemplates);
    }

    private void processTemplates(Map<String, Object> dataModel, List<Template> templateList) {
        for (Template template : templateList) {
            try {
                StringWriter sw = new StringWriter();
                Environment env = template.createProcessingEnvironment(dataModel, (Writer)sw);
                env.process();
                String fileName = env.getVariable("fileName").toString();
                if (!fileName.isEmpty()) {
                    this.context.getFileManager().writeSourceFile(fileName, sw);
                }
                sw.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to process template " + e.getMessage());
            }
        }
    }

    private TypeTemplate getTypeTemplate(Class<?> clazz) {
        if (clazz.isArray()) {
            return this.templates.getDatatypes().getArray();
        }
        if (clazz.isEnum()) {
            return this.templates.getDatatypes().getEnumeration();
        }
        for (TypeTemplate template : this.templates.getDatatypes().getTemplates()) {
            if (!template.getClazz().equals(clazz.getName())) continue;
            return template;
        }
        return this.templates.getDatatypes().getFallback();
    }

    public Template createTemplate(String template) {
        try {
            if (!Utils.isNullOrEmpty(template)) {
                return new Template("", template, this.configuration);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to process template " + e.getMessage());
        }
        return null;
    }

    public TypeTemplates getTypeTemplates(Class<?> clazz) {
        if (this.typeCache.containsKey(clazz)) {
            return this.typeCache.get(clazz);
        }
        TypeTemplates result = new TypeTemplates();
        TypeTemplate type = this.getTypeTemplate(clazz);
        if (type == null) {
            throw new RuntimeException("No defined template for type " + clazz.getName());
        }
        try {
            for (String templateName : type.getSourceTemplates()) {
                result.getSourceTemplates().add(this.configuration.getTemplate(templateName));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read templates: " + e.getMessage());
        }
        result.setNeedAnalyzing(type.getNeedAnalyzing());
        result.setCppType(this.createTemplate(type.getCppType()));
        result.setCppReturnType(this.createTemplate(type.getCppReturnType()));
        result.setDependencies(this.createTemplate(type.getDependencies()));
        HashMap<String, Template> functions = Utils.newHashMap();
        for (Function function : type.getFunctions()) {
            functions.put(function.getName(), this.createTemplate(function.getTemplate()));
        }
        result.setFunctions(functions);
        this.typeCache.put(clazz, result);
        return result;
    }
}

