/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp;

import com.github.loicoudot.java4cpp.Analyzer;
import com.github.loicoudot.java4cpp.Context;
import com.github.loicoudot.java4cpp.Datatype;
import com.github.loicoudot.java4cpp.model.ClassModel;
import com.github.loicoudot.java4cpp.model.ClassType;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.DeepUnwrap;
import java.util.Collection;
import java.util.List;

final class TypeAnalyzer
extends Analyzer {
    public TypeAnalyzer(Context context) {
        super(context);
    }

    @Override
    public void fill(ClassModel classModel) {
        ClassType typeModel = classModel.getType();
        Class<?> clazz = typeModel.getClazz();
        StringBuilder fullName = new StringBuilder();
        String shortName = "";
        String sep = "";
        for (String namespace : this.mappings.getNamespace(clazz)) {
            fullName.append(sep).append(namespace);
            sep = "::";
            shortName = namespace;
        }
        typeModel.setCppFullName(fullName.toString());
        typeModel.setCppShortName(shortName);
        typeModel.setOwner(typeModel.isIsInnerClass() ? this.context.getClassModel(clazz.getDeclaringClass()) : classModel);
        if (clazz.isArray()) {
            typeModel.setInnerType(this.context.getClassModel(clazz.getComponentType()));
            Class<?> finalClazz = clazz;
            while (finalClazz.getComponentType() != null) {
                finalClazz = finalClazz.getComponentType();
            }
            typeModel.setFinalInnerType(this.context.getClassModel(finalClazz));
        }
        typeModel.setJavaSignature(Datatype.getJavaSignature(clazz));
        typeModel.setJniSignature(Datatype.getJNISignature(clazz));
        typeModel.setJniMethodName(Datatype.getJNIMethodName(clazz));
        class AddIncludes
        implements TemplateMethodModelEx {
            ClassType model;

            public AddIncludes(ClassType model) {
                this.model = model;
            }

            public Object exec(List arguments) throws TemplateModelException {
                if (arguments.size() < 1) {
                    throw new TemplateModelException("addIncludes need at least one parameter.");
                }
                for (Object argument : arguments) {
                    Object include = DeepUnwrap.unwrap((TemplateModel)((TemplateModel)argument));
                    if (include instanceof String) {
                        this.model.getIncludes().add((String)include);
                        continue;
                    }
                    if (include instanceof Collection) {
                        this.model.getIncludes().addAll((Collection)include);
                        continue;
                    }
                    if (include == null) continue;
                    throw new TemplateModelException("addIncludes arguments must be a String or a Collection of Strings.");
                }
                return "";
            }
        }
        typeModel.setAddIncludes(new AddIncludes(typeModel));
        class AddDependencies
        implements TemplateMethodModelEx {
            ClassType model;

            public AddDependencies(ClassType model) {
                this.model = model;
            }

            public Object exec(List arguments) throws TemplateModelException {
                if (arguments.size() < 1) {
                    throw new TemplateModelException("addDependencies need at least one parameter.");
                }
                for (Object argument : arguments) {
                    Object dependency = DeepUnwrap.unwrap((TemplateModel)((TemplateModel)argument));
                    if (dependency instanceof String) {
                        this.addDependency(TypeAnalyzer.this.context.getClassModel((String)dependency));
                        continue;
                    }
                    if (dependency instanceof ClassModel) {
                        this.addDependency((ClassModel)dependency);
                        continue;
                    }
                    if (dependency instanceof Collection) {
                        for (Object depend : (Collection)dependency) {
                            this.addDependency((ClassModel)depend);
                        }
                        continue;
                    }
                    if (dependency == null) continue;
                    throw new TemplateModelException("addDependencies arguments must be a class name, a ClassModel instance or a Collection of ClassModels.");
                }
                return "";
            }

            private void addDependency(ClassModel classModel) {
                this.model.getDependencies().add(classModel);
            }
        }
        typeModel.setAddDependencies(new AddDependencies(typeModel));
    }
}

