/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp;

import com.github.loicoudot.java4cpp.Utils;
import com.github.loicoudot.java4cpp.model.ClassModel;
import freemarker.template.Template;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class TypeTemplates {
    private final List<Template> sourceTemplates = Utils.newArrayList();
    private boolean needAnalyzing;
    private Template cppType;
    private Template cppReturnType;
    private Template dependencies;
    private Map<String, Template> functions = Utils.newHashMap();

    TypeTemplates() {
    }

    private String processTemplate(Template template, Object model) {
        if (template != null) {
            StringWriter sw = new StringWriter();
            try {
                template.process(model, (Writer)sw);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to process template " + e.getMessage());
            }
            return sw.toString();
        }
        return "";
    }

    public List<Template> getSourceTemplates() {
        return this.sourceTemplates;
    }

    public boolean isNeedAnalyzing() {
        return this.needAnalyzing;
    }

    public void setNeedAnalyzing(boolean needAnalyzing) {
        this.needAnalyzing = needAnalyzing;
    }

    public String getCppType(ClassModel classModel) {
        return this.processTemplate(this.cppType, Utils.newHashMap("class", classModel));
    }

    public void setCppType(Template cppType) {
        this.cppType = cppType;
    }

    public String getCppReturnType(ClassModel classModel) {
        String type = this.processTemplate(this.cppReturnType, Utils.newHashMap("class", classModel));
        if (!type.isEmpty()) {
            return type;
        }
        return this.getCppType(classModel);
    }

    public void setCppReturnType(Template cppReturnType) {
        this.cppReturnType = cppReturnType;
    }

    public void executeDependencies(ClassModel classModel) {
        if (this.dependencies != null) {
            this.processTemplate(this.dependencies, Utils.newHashMap("class", classModel));
        }
    }

    public void setDependencies(Template dependencies) {
        this.dependencies = dependencies;
    }

    public HashMap<String, Object> getFunctions(ClassModel classModel) {
        HashMap<String, Object> result = Utils.newHashMap();
        for (String name : this.functions.keySet()) {
            result.put(name, new TemplateFunction(this.functions.get(name), classModel));
        }
        return result;
    }

    public void setFunctions(Map<String, Template> functions) {
        this.functions = functions;
    }

    public class TemplateFunction
    implements TemplateMethodModelEx {
        private final Template template;
        private ClassModel classModel;
        private final ThreadLocal<Map<String, Object>> model = new ThreadLocal();

        public TemplateFunction(Template template, ClassModel classModel) {
            this.template = template;
            this.classModel = classModel;
        }

        public TemplateFunction(Template template) {
            this.template = template;
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (this.template != null) {
                this.model.set(new HashMap());
                this.model.get().put("class", this.classModel);
                for (int i = 0; i < arguments.size(); ++i) {
                    this.model.get().put("arg" + (i + 1), arguments.get(i).toString());
                }
                return TypeTemplates.this.processTemplate(this.template, this.model.get());
            }
            return "";
        }
    }
}

