/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp.model;

import com.github.loicoudot.java4cpp.Utils;
import com.github.loicoudot.java4cpp.model.ClassModel;
import com.github.loicoudot.java4cpp.model.ConstructorModel;
import com.github.loicoudot.java4cpp.model.FieldModel;
import com.github.loicoudot.java4cpp.model.MethodModel;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassContent {
    private ClassModel superclass;
    private final List<ClassModel> interfaces = Utils.newArrayList();
    private final List<ClassModel> nestedClass = Utils.newArrayList();
    private final List<ConstructorModel> constructors = Utils.newArrayList();
    private final List<FieldModel> staticFields = Utils.newArrayList();
    private final List<MethodModel> methods = Utils.newArrayList();
    private final List<String> enumKeys = Utils.newArrayList();

    public ClassModel getSuperclass() {
        return this.superclass;
    }

    public void setSuperclass(ClassModel superclass) {
        this.superclass = superclass;
    }

    public List<ClassModel> getInterfaces() {
        return this.interfaces;
    }

    public void addInterface(ClassModel interfaceModel) {
        this.interfaces.add(interfaceModel);
    }

    public List<ClassModel> getNestedClass() {
        return this.nestedClass;
    }

    public void addNestedClass(ClassModel nestedClassModel) {
        this.nestedClass.add(nestedClassModel);
    }

    public List<ConstructorModel> getConstructors() {
        return this.constructors;
    }

    public void addConstructor(ConstructorModel constructorModel) {
        this.constructors.add(constructorModel);
    }

    public List<FieldModel> getStaticFields() {
        return this.staticFields;
    }

    public void addField(FieldModel fieldModel) {
        this.staticFields.add(fieldModel);
    }

    public List<MethodModel> getMethods() {
        return this.methods;
    }

    public void addMethod(MethodModel methodModel) {
        this.methods.add(methodModel);
    }

    public List<String> getEnumKeys() {
        return this.enumKeys;
    }

    public void addEnumKey(String key) {
        this.enumKeys.add(key);
    }

    public Set<String> getIncludes() {
        HashSet<String> includes = Utils.newHashSet();
        for (ClassModel nested : this.getNestedClass()) {
            includes.addAll(nested.getContent().getIncludes());
        }
        for (ConstructorModel constructor : this.getConstructors()) {
            for (ClassModel parameter : constructor.getParameters()) {
                includes.addAll(parameter.getType().getIncludes());
            }
        }
        for (FieldModel field : this.getStaticFields()) {
            includes.addAll(field.getType().getType().getIncludes());
        }
        for (MethodModel method : this.getMethods()) {
            includes.addAll(method.getReturnType().getType().getIncludes());
            for (ClassModel parameter : method.getParameters()) {
                includes.addAll(parameter.getType().getIncludes());
            }
        }
        return includes;
    }

    public Set<ClassModel> getDependencies() {
        HashSet<ClassModel> dependencies = Utils.newHashSet();
        if (this.superclass != null) {
            dependencies.add(this.superclass);
        }
        for (ClassModel interfaze : this.getInterfaces()) {
            dependencies.add(interfaze);
        }
        for (ClassModel nested : this.getNestedClass()) {
            dependencies.addAll(nested.getContent().getDependencies());
        }
        for (ConstructorModel constructor : this.getConstructors()) {
            for (ClassModel parameter : constructor.getParameters()) {
                dependencies.addAll(parameter.getType().getDependencies());
            }
        }
        for (FieldModel field : this.getStaticFields()) {
            dependencies.addAll(field.getType().getType().getDependencies());
        }
        for (MethodModel method : this.getMethods()) {
            dependencies.addAll(method.getReturnType().getType().getDependencies());
            for (ClassModel parameter : method.getParameters()) {
                dependencies.addAll(parameter.getType().getDependencies());
            }
        }
        return dependencies;
    }
}

