/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp.model;

import com.github.loicoudot.java4cpp.Java4CppType;
import com.github.loicoudot.java4cpp.Utils;
import com.github.loicoudot.java4cpp.model.ClassContent;
import com.github.loicoudot.java4cpp.model.ClassType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ClassModel {
    private ClassType type;
    private List<ClassModel> parameters;
    private ClassContent content;

    public ClassModel(Java4CppType type) {
        this.type = new ClassType(type);
        this.content = new ClassContent();
    }

    public void setRawClassModel(ClassModel classModel) {
        this.type = classModel.getType();
        this.content = classModel.getContent();
    }

    public ClassType getType() {
        return this.type;
    }

    public List<ClassModel> getParameters() {
        return this.parameters;
    }

    public void addParameter(ClassModel parameter) {
        if (this.parameters == null) {
            this.parameters = Utils.newArrayList();
        }
        this.parameters.add(parameter);
    }

    public ClassContent getContent() {
        return this.content;
    }

    public Set<String> getIncludes() {
        HashSet<String> result = Utils.newHashSet();
        result.addAll(this.getType().getIncludes());
        result.addAll(this.getContent().getIncludes());
        return result;
    }

    public Set<ClassModel> getDependencies() {
        HashSet<ClassModel> result = Utils.newHashSet();
        result.addAll(this.getType().getDependencies());
        result.addAll(this.getContent().getDependencies());
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.getType().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassModel other = (ClassModel)obj;
        return !(this.type == null ? other.type != null : !this.type.getType().equals(other.type.getType()));
    }

    public String toString() {
        return String.format("class(%s)", this.type.getType());
    }
}

