/*
 * Decompiled with CFR 0.152.
 */
package com.github.loicoudot.java4cpp.model;

import com.github.loicoudot.java4cpp.Java4CppType;
import com.github.loicoudot.java4cpp.Utils;
import com.github.loicoudot.java4cpp.model.ClassModel;
import freemarker.template.TemplateMethodModelEx;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class ClassType {
    private final Java4CppType type;
    private final String javaName;
    private final boolean isPrimitive;
    private final boolean isEnum;
    private final boolean isArray;
    private final boolean isInterface;
    private final boolean isInnerClass;
    private final boolean isThrowable;
    private final boolean isCheckedException;
    private final boolean isCloneable;
    private final boolean isAbstract;
    private String cppFullName;
    private String cppShortName;
    private ClassModel owner;
    private String javaSignature;
    private String jniSignature;
    private String jniMethodName;
    private String cppType;
    private String cppReturnType;
    private ClassModel innerType;
    private ClassModel finalInnerType;
    private HashMap<String, Object> functions;
    private TemplateMethodModelEx addIncludes;
    private TemplateMethodModelEx addDependencies;
    private final Set<String> includes = Utils.newHashSet();
    private final Set<ClassModel> dependencies = Utils.newHashSet();

    public ClassType(Java4CppType type) {
        this.type = type;
        Class<?> clazz = this.getClazz();
        this.javaName = clazz.getName();
        this.isAbstract = Modifier.isAbstract(clazz.getModifiers());
        this.isPrimitive = clazz.isPrimitive();
        this.isEnum = clazz.isEnum();
        this.isArray = clazz.isArray();
        this.isInterface = clazz.isInterface();
        this.isInnerClass = clazz.getEnclosingClass() != null;
        this.isThrowable = this.isThrowable(clazz);
        this.isCheckedException = this.isCheckedException(clazz);
        this.isCloneable = Arrays.asList(clazz.getInterfaces()).contains(Cloneable.class);
    }

    public Java4CppType getType() {
        return this.type;
    }

    public Class<?> getClazz() {
        return this.type.getRawClass();
    }

    public String getJavaName() {
        return this.javaName;
    }

    public boolean isIsPrimitive() {
        return this.isPrimitive;
    }

    public boolean isIsEnum() {
        return this.isEnum;
    }

    public boolean isIsArray() {
        return this.isArray;
    }

    public boolean isIsInterface() {
        return this.isInterface;
    }

    public boolean isIsInnerClass() {
        return this.isInnerClass;
    }

    public boolean isIsThrowable() {
        return this.isThrowable;
    }

    public boolean isIsCheckedException() {
        return this.isCheckedException;
    }

    public boolean isIsCloneable() {
        return this.isCloneable;
    }

    public boolean isIsAbstract() {
        return this.isAbstract;
    }

    public String getCppFullName() {
        return this.cppFullName;
    }

    public void setCppFullName(String cppFullName) {
        this.cppFullName = cppFullName;
    }

    public String getCppShortName() {
        return this.cppShortName;
    }

    public void setCppShortName(String cppShortName) {
        this.cppShortName = cppShortName;
    }

    public ClassModel getOwner() {
        return this.owner;
    }

    public void setOwner(ClassModel owner) {
        this.owner = owner;
    }

    public String getJavaSignature() {
        return this.javaSignature;
    }

    public void setJavaSignature(String javaSignature) {
        this.javaSignature = javaSignature;
    }

    public String getJniSignature() {
        return this.jniSignature;
    }

    public void setJniSignature(String jniSignature) {
        this.jniSignature = jniSignature;
    }

    public String getJniMethodName() {
        return this.jniMethodName;
    }

    public void setJniMethodName(String jniMethodName) {
        this.jniMethodName = jniMethodName;
    }

    public String getCppType() {
        return this.cppType;
    }

    public void setCppType(String cppType) {
        this.cppType = cppType;
    }

    public String getCppReturnType() {
        return this.cppReturnType;
    }

    public void setCppReturnType(String cppReturnType) {
        this.cppReturnType = cppReturnType;
    }

    public ClassModel getInnerType() {
        return this.innerType;
    }

    public void setInnerType(ClassModel innerType) {
        this.innerType = innerType;
    }

    public ClassModel getFinalInnerType() {
        return this.finalInnerType;
    }

    public void setFinalInnerType(ClassModel finalInnerType) {
        this.finalInnerType = finalInnerType;
    }

    public HashMap<String, Object> getFunctions() {
        return this.functions;
    }

    public void setFunctions(HashMap<String, Object> functions) {
        this.functions = functions;
    }

    public TemplateMethodModelEx getAddIncludes() {
        return this.addIncludes;
    }

    public void setAddIncludes(TemplateMethodModelEx addInclude) {
        this.addIncludes = addInclude;
    }

    public TemplateMethodModelEx getAddDependencies() {
        return this.addDependencies;
    }

    public void setAddDependencies(TemplateMethodModelEx addDependencies) {
        this.addDependencies = addDependencies;
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public Set<ClassModel> getDependencies() {
        return this.dependencies;
    }

    private boolean isThrowable(Class<?> clazz) {
        Class<?> current = clazz;
        do {
            if (current != Throwable.class) continue;
            return true;
        } while ((current = current.getSuperclass()) != null);
        return false;
    }

    private boolean isCheckedException(Class<?> clazz) {
        Class<?> current = clazz;
        do {
            if (current == RuntimeException.class || current == Error.class) {
                return false;
            }
            if (current != Throwable.class) continue;
            return true;
        } while ((current = current.getSuperclass()) != null);
        return false;
    }

    public String toString() {
        return String.format("type(%s)", this.type);
    }
}

