/*
 * Decompiled with CFR 0.152.
 */
package lbmq;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import lbmq.AbstractOfferable;
import lbmq.AbstractPollable;
import lbmq.DefaultSubQueueSelection;

public class LinkedBlockingMultiQueue<K, E>
extends AbstractPollable<E> {
    private final ConcurrentHashMap<K, SubQueue> subQueues = new ConcurrentHashMap();
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();
    private final AtomicInteger totalCount = new AtomicInteger();
    private final ArrayList<PriorityGroup> priorityGroups = new ArrayList();
    private final SubQueueSelection<K, E> subQueueSelection;

    public LinkedBlockingMultiQueue() {
        this(new DefaultSubQueueSelection());
    }

    public LinkedBlockingMultiQueue(SubQueueSelection<K, E> subQueueSelection) {
        this.subQueueSelection = subQueueSelection;
        this.subQueueSelection.setPriorityGroups(this.priorityGroups);
    }

    public SubQueue addSubQueue(K key, int priority) {
        return this.addSubQueue(key, priority, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubQueue addSubQueue(K key, int priority, int capacity) {
        SubQueue subQueue = new SubQueue(key, capacity);
        this.takeLock.lock();
        try {
            SubQueue old = this.subQueues.putIfAbsent(key, subQueue);
            if (old == null) {
                int i = 0;
                boolean added = false;
                for (PriorityGroup pg : this.priorityGroups) {
                    if (pg.priority == priority) {
                        pg.addQueue(subQueue);
                        added = true;
                        break;
                    }
                    if (pg.priority > priority) {
                        PriorityGroup newPg = new PriorityGroup(priority);
                        this.priorityGroups.add(i, newPg);
                        newPg.addQueue(subQueue);
                        added = true;
                        break;
                    }
                    ++i;
                }
                if (!added) {
                    PriorityGroup newPg = new PriorityGroup(priority);
                    this.priorityGroups.add(newPg);
                    newPg.addQueue(subQueue);
                }
            }
            SubQueue subQueue2 = old;
            return subQueue2;
        }
        finally {
            this.takeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubQueue removeSubQueue(K key) {
        this.takeLock.lock();
        try {
            SubQueue removed = this.subQueues.remove(key);
            if (removed != null) {
                removed.priorityGroup.removeQueue(removed);
                if (((SubQueue)removed).priorityGroup.queues.size() == 0) {
                    this.priorityGroups.remove(removed.priorityGroup);
                }
            }
            SubQueue subQueue = removed;
            return subQueue;
        }
        finally {
            this.takeLock.unlock();
        }
    }

    public SubQueue getSubQueue(K key) {
        return this.subQueues.get(key);
    }

    private void signalNotEmpty() {
        this.takeLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            this.takeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        int oldSize;
        Object element;
        SubQueue subQueue;
        long remaining = unit.toNanos(timeout);
        this.takeLock.lockInterruptibly();
        try {
            while (this.totalCount.get() == 0) {
                if (remaining <= 0L) {
                    E e = null;
                    return e;
                }
                remaining = this.notEmpty.awaitNanos(remaining);
            }
            subQueue = this.subQueueSelection.getNext();
            element = subQueue.dequeue();
            oldSize = subQueue.count.getAndDecrement();
            if (this.totalCount.getAndDecrement() > 1) {
                this.notEmpty.signal();
            }
        }
        finally {
            this.takeLock.unlock();
        }
        if (oldSize == subQueue.capacity) {
            subQueue.signalNotFull();
        }
        return (E)element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        int oldSize;
        Object element;
        SubQueue subQueue;
        this.takeLock.lockInterruptibly();
        try {
            while (this.totalCount.get() == 0) {
                this.notEmpty.await();
            }
            subQueue = this.subQueueSelection.getNext();
            element = subQueue.dequeue();
            oldSize = subQueue.count.getAndDecrement();
            if (this.totalCount.getAndDecrement() > 1) {
                this.notEmpty.signal();
            }
        }
        finally {
            this.takeLock.unlock();
        }
        if (oldSize == subQueue.capacity) {
            subQueue.signalNotFull();
        }
        return (E)element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        int oldSize;
        Object element;
        SubQueue subQueue;
        this.takeLock.lock();
        try {
            if (this.totalCount.get() == 0) {
                E e = null;
                return e;
            }
            subQueue = this.subQueueSelection.getNext();
            element = subQueue.dequeue();
            oldSize = subQueue.count.getAndDecrement();
            if (this.totalCount.getAndDecrement() > 1) {
                this.notEmpty.signal();
            }
        }
        finally {
            this.takeLock.unlock();
        }
        if (oldSize == subQueue.capacity) {
            subQueue.signalNotFull();
        }
        return (E)element;
    }

    @Override
    public E peek() {
        this.takeLock.lock();
        try {
            if (this.totalCount.get() == 0) {
                E e = null;
                return e;
            }
            E e = this.subQueueSelection.peek();
            return e;
        }
        finally {
            this.takeLock.unlock();
        }
    }

    public int totalSize() {
        return this.totalCount.get();
    }

    public boolean isEmpty() {
        return this.totalSize() == 0;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        this.takeLock.lock();
        try {
            int n = Math.min(maxElements, this.totalCount.get());
            int drained = 0;
            for (int i = 0; i < this.priorityGroups.size() && drained < n; drained += this.priorityGroups.get(i).drainTo(c, n - drained), ++i) {
            }
            this.totalCount.getAndAdd(-drained);
            int n2 = drained;
            return n2;
        }
        finally {
            this.takeLock.unlock();
        }
    }

    public int getPriorityGroupsCount() {
        return this.priorityGroups.size();
    }

    public static interface SubQueueSelection<K, E> {
        public SubQueue getNext();

        public E peek();

        public void setPriorityGroups(ArrayList<PriorityGroup> var1);
    }

    private static class Node<E> {
        E item;
        Node<E> next = null;

        Node(E item) {
            this.item = item;
        }
    }

    public class SubQueue
    extends AbstractOfferable<E> {
        private final K key;
        private final int capacity;
        private PriorityGroup priorityGroup;
        private final ReentrantLock putLock = new ReentrantLock();
        private final Condition notFull = this.putLock.newCondition();
        private final AtomicInteger count = new AtomicInteger();
        private boolean enabled = true;
        private Node<E> head = new Node<Object>(null);
        private Node<E> last = this.head;

        SubQueue(K key, int capacity) {
            if (capacity <= 0) {
                throw new IllegalArgumentException();
            }
            this.key = key;
            this.capacity = capacity;
        }

        @Override
        public int remainingCapacity() {
            return this.capacity - this.count.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            this.fullyLock();
            try {
                Node h = this.head;
                Node p = h.next;
                while (p != null) {
                    h.next = h;
                    p.item = null;
                    h = p;
                    p = h.next;
                }
                this.head = this.last;
                int oldCapacity = this.count.getAndSet(0);
                if (oldCapacity == this.capacity) {
                    this.notFull.signal();
                }
                if (this.enabled) {
                    LinkedBlockingMultiQueue.this.totalCount.getAndAdd(-oldCapacity);
                }
            }
            finally {
                this.fullyUnlock();
            }
        }

        public void enable(boolean status) {
            this.fullyLock();
            try {
                this.enabled = status;
                if (status) {
                    int c = this.count.get();
                    if (c > 0) {
                        LinkedBlockingMultiQueue.this.totalCount.getAndAdd(c);
                        LinkedBlockingMultiQueue.this.notEmpty.signal();
                    }
                } else {
                    LinkedBlockingMultiQueue.this.totalCount.getAndAdd(-this.count.get());
                }
            }
            finally {
                this.fullyUnlock();
            }
        }

        public boolean isEnabled() {
            LinkedBlockingMultiQueue.this.takeLock.lock();
            try {
                boolean bl = this.enabled;
                return bl;
            }
            finally {
                LinkedBlockingMultiQueue.this.takeLock.unlock();
            }
        }

        private void signalNotFull() {
            this.putLock.lock();
            try {
                this.notFull.signal();
            }
            finally {
                this.putLock.unlock();
            }
        }

        private void enqueue(Node<E> node) {
            this.last.next = node;
            this.last = node;
        }

        @Override
        public int size() {
            return this.count.get();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(E e) throws InterruptedException {
            if (e == null) {
                throw new NullPointerException();
            }
            long oldSize = -1L;
            Node node = new Node(e);
            this.putLock.lockInterruptibly();
            try {
                while (this.count.get() == this.capacity) {
                    this.notFull.await();
                }
                this.enqueue(node);
                if (this.count.getAndIncrement() + 1 < this.capacity) {
                    this.notFull.signal();
                }
                if (this.enabled) {
                    oldSize = LinkedBlockingMultiQueue.this.totalCount.getAndIncrement();
                }
            }
            finally {
                this.putLock.unlock();
            }
            if (oldSize == 0L) {
                LinkedBlockingMultiQueue.this.signalNotEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
            if (e == null) {
                throw new NullPointerException();
            }
            long nanos = unit.toNanos(timeout);
            long oldSize = -1L;
            this.putLock.lockInterruptibly();
            try {
                while (this.count.get() == this.capacity) {
                    if (nanos <= 0L) {
                        boolean bl = false;
                        return bl;
                    }
                    nanos = this.notFull.awaitNanos(nanos);
                }
                this.enqueue(new Node(e));
                if (this.count.getAndIncrement() + 1 < this.capacity) {
                    this.notFull.signal();
                }
                if (this.enabled) {
                    oldSize = LinkedBlockingMultiQueue.this.totalCount.getAndIncrement();
                }
            }
            finally {
                this.putLock.unlock();
            }
            if (oldSize == 0L) {
                LinkedBlockingMultiQueue.this.signalNotEmpty();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean offer(E e) {
            if (e == null) {
                throw new NullPointerException();
            }
            long oldSize = -1L;
            if (this.count.get() == this.capacity) {
                return false;
            }
            this.putLock.lock();
            try {
                if (this.count.get() == this.capacity) {
                    boolean bl = false;
                    return bl;
                }
                this.enqueue(new Node(e));
                if (this.count.getAndIncrement() + 1 < this.capacity) {
                    this.notFull.signal();
                }
                if (this.enabled) {
                    oldSize = LinkedBlockingMultiQueue.this.totalCount.getAndIncrement();
                }
            }
            finally {
                this.putLock.unlock();
            }
            if (oldSize == 0L) {
                LinkedBlockingMultiQueue.this.signalNotEmpty();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            if (o == null) {
                return false;
            }
            this.fullyLock();
            try {
                Node trail = this.head;
                Node p = trail.next;
                while (p != null) {
                    if (o.equals(p.item)) {
                        this.unlink(p, trail);
                        boolean bl = true;
                        return bl;
                    }
                    trail = p;
                    p = p.next;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.fullyUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return false;
            }
            this.fullyLock();
            try {
                Node p = this.head.next;
                while (p != null) {
                    if (o.equals(p.item)) {
                        boolean bl = true;
                        return bl;
                    }
                    p = p.next;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.fullyUnlock();
            }
        }

        void unlink(Node<E> p, Node<E> trail) {
            p.item = null;
            trail.next = p.next;
            if (this.last == p) {
                this.last = trail;
            }
            if (this.count.getAndDecrement() == this.capacity) {
                this.notFull.signal();
            }
            if (this.enabled) {
                LinkedBlockingMultiQueue.this.totalCount.getAndDecrement();
            }
        }

        private void fullyLock() {
            LinkedBlockingMultiQueue.this.takeLock.lock();
            this.putLock.lock();
        }

        private void fullyUnlock() {
            this.putLock.unlock();
            LinkedBlockingMultiQueue.this.takeLock.unlock();
        }

        private E dequeue() {
            Node h = this.head;
            Node first = h.next;
            h.next = h;
            this.head = first;
            Object x = first.item;
            first.item = null;
            return x;
        }

        @Override
        public String toString() {
            this.fullyLock();
            try {
                Node p = this.head.next;
                if (p == null) {
                    String string = "[]";
                    return string;
                }
                StringBuilder sb = new StringBuilder();
                sb.append('[');
                while (true) {
                    Object e;
                    sb.append((Object)((e = p.item) == this ? "(this Collection)" : e));
                    p = p.next;
                    if (p == null) {
                        String string = sb.append(']').toString();
                        return string;
                    }
                    sb.append(',').append(' ');
                }
            }
            finally {
                this.fullyUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            this.fullyLock();
            try {
                int size = this.count.get();
                Object[] a = new Object[size];
                int k = 0;
                Node p = this.head.next;
                while (p != null) {
                    a[k++] = p.item;
                    p = p.next;
                }
                Object[] objectArray = a;
                return objectArray;
            }
            finally {
                this.fullyUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            this.fullyLock();
            try {
                int size = this.count.get();
                if (a.length < size) {
                    a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
                }
                int k = 0;
                Node p = this.head.next;
                while (p != null) {
                    a[k++] = p.item;
                    p = p.next;
                }
                if (a.length > k) {
                    a[k] = null;
                }
                Object[] objectArray = a;
                return objectArray;
            }
            finally {
                this.fullyUnlock();
            }
        }

        @Override
        public Iterator<E> iterator() {
            return new Itr();
        }

        private class Itr
        implements Iterator<E> {
            private Node<E> current;
            private Node<E> lastRet;
            private E currentElement;

            Itr() {
                SubQueue.this.fullyLock();
                try {
                    this.current = ((SubQueue)SubQueue.this).head.next;
                    if (this.current != null) {
                        this.currentElement = this.current.item;
                    }
                }
                finally {
                    SubQueue.this.fullyUnlock();
                }
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            private Node<E> nextNode(Node<E> p) {
                Node s;
                while ((s = p.next) != p) {
                    if (s == null || s.item != null) {
                        return s;
                    }
                    p = s;
                }
                return ((SubQueue)SubQueue.this).head.next;
            }

            @Override
            public E next() {
                SubQueue.this.fullyLock();
                try {
                    if (this.current == null) {
                        throw new NoSuchElementException();
                    }
                    Object x = this.currentElement;
                    this.lastRet = this.current;
                    this.current = this.nextNode(this.current);
                    this.currentElement = this.current == null ? null : this.current.item;
                    Object e = x;
                    return e;
                }
                finally {
                    SubQueue.this.fullyUnlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                if (this.lastRet == null) {
                    throw new IllegalStateException();
                }
                SubQueue.this.fullyLock();
                try {
                    Node node = this.lastRet;
                    this.lastRet = null;
                    Node trail = SubQueue.this.head;
                    Node p = trail.next;
                    while (p != null) {
                        if (p == node) {
                            SubQueue.this.unlink(p, trail);
                            break;
                        }
                        trail = p;
                        p = p.next;
                    }
                }
                finally {
                    SubQueue.this.fullyUnlock();
                }
            }
        }
    }

    class PriorityGroup {
        final int priority;
        final ArrayList<SubQueue> queues = new ArrayList(0);
        int nextIdx = 0;

        PriorityGroup(int priority) {
            this.priority = priority;
        }

        void addQueue(SubQueue subQueue) {
            this.queues.add(subQueue);
            subQueue.priorityGroup = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeQueue(SubQueue removed) {
            Iterator<SubQueue> it = this.queues.iterator();
            while (it.hasNext()) {
                SubQueue subQueue = it.next();
                if (subQueue.key != removed.key) continue;
                removed.putLock.lock();
                try {
                    it.remove();
                    if (this.nextIdx == this.queues.size()) {
                        this.nextIdx = 0;
                    }
                    if (subQueue.enabled) {
                        LinkedBlockingMultiQueue.this.totalCount.getAndAdd(-removed.size());
                    }
                    return;
                }
                finally {
                    removed.putLock.unlock();
                }
            }
        }

        SubQueue getNextSubQueue() {
            int startIdx = this.nextIdx;
            ArrayList<SubQueue> queues = this.queues;
            do {
                SubQueue child = queues.get(this.nextIdx);
                ++this.nextIdx;
                if (this.nextIdx == queues.size()) {
                    this.nextIdx = 0;
                }
                if (!child.enabled || child.size() <= 0) continue;
                return child;
            } while (this.nextIdx != startIdx);
            return null;
        }

        int drainTo(Collection<? super E> c, int maxElements) {
            int drained = 0;
            int emptyQueues = 0;
            do {
                SubQueue child = this.queues.get(this.nextIdx);
                ++this.nextIdx;
                if (this.nextIdx == this.queues.size()) {
                    this.nextIdx = 0;
                }
                if (child.enabled && child.size() > 0) {
                    emptyQueues = 0;
                    c.add(child.dequeue());
                    ++drained;
                    int oldSize = child.count.getAndDecrement();
                    if (oldSize != child.capacity) continue;
                    child.signalNotFull();
                    continue;
                }
                ++emptyQueues;
            } while (drained < maxElements && emptyQueues < this.queues.size());
            return drained;
        }

        E peek() {
            int startIdx = this.nextIdx;
            do {
                SubQueue child;
                if ((child = this.queues.get(this.nextIdx)).enabled && child.size() > 0) {
                    return ((SubQueue)child).head.next.item;
                }
                ++this.nextIdx;
                if (this.nextIdx != this.queues.size()) continue;
                this.nextIdx = 0;
            } while (this.nextIdx != startIdx);
            return null;
        }
    }
}

