/*
 * Decompiled with CFR 0.152.
 */
package com.github.mayp1998.taskExecutor.util;

import com.github.mayp1998.taskExecutor.bean.Task;
import java.util.Date;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.ScheduleBuilder;
import org.quartz.TriggerBuilder;

public class TaskRunnable
implements Runnable {
    private Runnable runnable;
    private String cron;
    private Task task;
    private ScheduledExecutorService service;
    private Future<?> future;

    public TaskRunnable(Runnable runnable, String cron, Task task, ScheduledExecutorService service) {
        this.runnable = runnable;
        this.cron = cron;
        this.task = task;
        this.service = service;
    }

    @Override
    public void run() {
        this.runnable.run();
        if (this.task.getFuture() != null) {
            this.future = this.service.schedule(this, this.getNextTriggerTime(), TimeUnit.MILLISECONDS);
            Future<?> last = this.task.getFuture();
            this.task.setFuture(this.future);
            last.cancel(true);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.future.cancel(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    public long getNextTriggerTime() {
        if (!CronExpression.isValidExpression((String)this.cron)) {
            return 0L;
        }
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("Caclulate Date").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.cron)).build();
        Date time0 = trigger.getStartTime();
        Date time1 = trigger.getFireTimeAfter(time0);
        return time1.getTime() - new Date().getTime();
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public String getCron() {
        return this.cron;
    }

    public Task getTask() {
        return this.task;
    }

    public ScheduledExecutorService getService() {
        return this.service;
    }

    public Future<?> getFuture() {
        return this.future;
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public void setService(ScheduledExecutorService service) {
        this.service = service;
    }

    public void setFuture(Future<?> future) {
        this.future = future;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskRunnable)) {
            return false;
        }
        TaskRunnable other = (TaskRunnable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Runnable this$runnable = this.getRunnable();
        Runnable other$runnable = other.getRunnable();
        if (this$runnable == null ? other$runnable != null : !this$runnable.equals(other$runnable)) {
            return false;
        }
        String this$cron = this.getCron();
        String other$cron = other.getCron();
        if (this$cron == null ? other$cron != null : !this$cron.equals(other$cron)) {
            return false;
        }
        Task this$task = this.getTask();
        Task other$task = other.getTask();
        if (this$task == null ? other$task != null : !this$task.equals(other$task)) {
            return false;
        }
        ScheduledExecutorService this$service = this.getService();
        ScheduledExecutorService other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        Future<?> this$future = this.getFuture();
        Future<?> other$future = other.getFuture();
        return !(this$future == null ? other$future != null : !this$future.equals(other$future));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskRunnable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Runnable $runnable = this.getRunnable();
        result = result * 59 + ($runnable == null ? 43 : $runnable.hashCode());
        String $cron = this.getCron();
        result = result * 59 + ($cron == null ? 43 : $cron.hashCode());
        Task $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : $task.hashCode());
        ScheduledExecutorService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        Future<?> $future = this.getFuture();
        result = result * 59 + ($future == null ? 43 : $future.hashCode());
        return result;
    }

    public String toString() {
        return "TaskRunnable(runnable=" + this.getRunnable() + ", cron=" + this.getCron() + ", task=" + this.getTask() + ", service=" + this.getService() + ", future=" + this.getFuture() + ")";
    }
}

