/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.io;

import com.github.libxjava.io.IDeserialiser;
import com.github.libxjava.io.ISerialisable;
import com.github.libxjava.lang.IClassLoader;
import com.github.libxjava.util.IntHashMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class BinaryDeserialiserStream
extends DataInputStream
implements IDeserialiser {
    private IntHashMap _references = new IntHashMap();
    private int _referenceCounter = 0;
    private IClassLoader _classLoader;

    public BinaryDeserialiserStream(IClassLoader classLoader, InputStream in) {
        super(in);
        this._classLoader = classLoader;
    }

    public void flush() {
        this._references.clear();
        this._referenceCounter = 0;
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        Object result = null;
        int type = this.readUnsignedByte();
        switch (type) {
            case 1: {
                return null;
            }
            case 2: {
                return this._references.get(this.readByte());
            }
            case 3: {
                return this.readSerialisable(this.readUTF());
            }
            case 12: {
                result = this.readUTF();
                break;
            }
            case 4: {
                result = this.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 5: {
                result = new Byte(this.readByte());
                break;
            }
            case 6: {
                result = new Character(this.readChar());
                break;
            }
            case 7: {
                result = new Double(this.readDouble());
                break;
            }
            case 8: {
                result = new Float(this.readFloat());
                break;
            }
            case 9: {
                result = new Integer(this.readInt());
                break;
            }
            case 10: {
                result = new Long(this.readLong());
                break;
            }
            case 11: {
                result = new Short(this.readShort());
            }
        }
        if (result == null) {
            throw new IOException("unexpected type: '" + type + "'");
        }
        this.insertReference(result);
        return result;
    }

    private void insertReference(Object obj) {
        this._references.put(this._referenceCounter++, obj);
    }

    private ISerialisable readSerialisable(String className) throws ClassNotFoundException, IOException {
        try {
            ISerialisable result = (ISerialisable)this._classLoader.loadClass(className).newInstance();
            this.insertReference(result);
            result.deserialise(this);
            return result;
        }
        catch (IllegalAccessException iae) {
            throw new ClassNotFoundException("cannot access class '" + className + "' : " + iae.getMessage());
        }
        catch (InstantiationException ie) {
            throw new ClassNotFoundException("cannot instantiate class '" + className + "' : " + ie.getMessage());
        }
    }
}

