/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.io;

import com.github.libxjava.io.BinarySerialiserConstants;
import com.github.libxjava.io.ISerialisable;
import com.github.libxjava.io.ISerialiser;
import com.github.libxjava.util.BasicHashMap;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class BinarySerialiserStream
extends DataOutputStream
implements ISerialiser {
    private BasicHashMap _references = new BasicHashMap();
    private byte _referenceCounter = 0;

    public BinarySerialiserStream(OutputStream out) {
        super(out);
    }

    public void flush() throws IOException {
        this._references.clear();
        this._referenceCounter = 0;
        super.flush();
    }

    public void writeObject(Object o) throws IOException {
        if (o == null) {
            this.writeByte(1);
            return;
        }
        if (this._references.containsKey(o)) {
            Byte ref = (Byte)this._references.get(o);
            this.writeByte(2);
            this.writeByte((int)(ref & 0xFF));
            return;
        }
        if (o instanceof ISerialisable) {
            this.writeByte(3);
            this.insertReference(o);
            this.writeUTF(o.getClass().getName());
            ((ISerialisable)o).serialise(this);
            return;
        }
        byte type = BinarySerialiserConstants.getType(o.getClass().getName());
        if (type < 0) {
            throw new IOException("object of class + '" + o.getClass().getName() + "' cannot be serialised");
        }
        this.writeByte(type);
        switch (type) {
            case 12: {
                this.writeUTF((String)o);
                break;
            }
            case 4: {
                this.writeBoolean((Boolean)o);
                break;
            }
            case 5: {
                this.writeByte(((Byte)o).byteValue());
                break;
            }
            case 6: {
                this.writeChar(((Character)o).charValue());
                break;
            }
            case 7: {
                this.writeDouble((Double)o);
                break;
            }
            case 8: {
                this.writeFloat(((Float)o).floatValue());
                break;
            }
            case 9: {
                this.writeInt((Integer)o);
                break;
            }
            case 10: {
                this.writeLong((Long)o);
                break;
            }
            case 11: {
                this.writeShort(((Short)o).shortValue());
            }
        }
        this.insertReference(o);
    }

    private void insertReference(Object obj) {
        if (obj == null || this._references.containsKey(obj)) {
            return;
        }
        byte by = this._referenceCounter;
        this._referenceCounter = (byte)(by + 1);
        Byte value = new Byte(by);
        this._references.put(obj, value);
    }
}

