/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.concurrent;

public final class Semaphore {
    private int _permits;
    private final Object _sync;

    public Semaphore(int permits) {
        this._permits = permits;
        this._sync = new Object();
    }

    public void acquire() {
        this.acquire(1);
    }

    public void acquire(int permits) {
        if (permits <= 0) {
            throw new IllegalArgumentException("permits must be a positive value");
        }
        boolean interrupted = false;
        while (true) {
            try {
                this.acquireInterruptibly(permits);
            }
            catch (InterruptedException ie) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public void acquireInterruptibly() throws InterruptedException {
        this.acquireInterruptibly(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireInterruptibly(int permits) throws InterruptedException, IllegalArgumentException {
        if (permits <= 0) {
            throw new IllegalArgumentException("permits must be a positive value");
        }
        Object object = this._sync;
        synchronized (object) {
            while (this._permits < permits) {
                this._sync.wait();
            }
            this._permits -= permits;
        }
    }

    public void release() {
        this.release(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(int permits) {
        if (permits <= 0) {
            throw new IllegalArgumentException("permits must be a positive value");
        }
        Object object = this._sync;
        synchronized (object) {
            this._permits += permits;
            this._sync.notify();
        }
    }

    public boolean tryAcquire() {
        return this.tryAcquire(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAcquire(int permits) {
        if (permits <= 0) {
            throw new IllegalArgumentException("permits must be a positive value");
        }
        Object object = this._sync;
        synchronized (object) {
            if (this._permits >= permits) {
                this._permits -= permits;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPermits() {
        Object object = this._sync;
        synchronized (object) {
            return this._permits;
        }
    }
}

