/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.io;

import java.io.IOException;
import java.io.OutputStream;

public abstract class BufferedOutputStream
extends OutputStream {
    protected final int bufsize;
    private byte[] _buffer;
    private int _position;
    protected final Object worklock = new Object();

    protected BufferedOutputStream(int bufsize) {
        this.bufsize = bufsize;
    }

    public void close() throws IOException {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Object object = this.worklock;
        synchronized (object) {
            this._buffer = null;
            this._position = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() throws IOException {
        Object object = this.worklock;
        synchronized (object) {
            if (this._buffer != null && this._position > 0) {
                this.internalWrite(this._buffer, this._position, true);
                this.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new IllegalArgumentException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        Object object = this.worklock;
        synchronized (object) {
            this.ensureBufferNotNull();
            int offset = off;
            int length = len;
            while (length > 0) {
                this.checkBuffer();
                int canWrite = this.getPayloadEnd() - this._position;
                int toWrite = length > canWrite ? canWrite : length;
                System.arraycopy(b, offset, this._buffer, this._position, toWrite);
                offset += toWrite;
                length -= toWrite;
                this._position += toWrite;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(int b) throws IOException {
        Object object = this.worklock;
        synchronized (object) {
            this.ensureBufferNotNull();
            this.checkBuffer();
            this._buffer[this._position++] = (byte)b;
        }
    }

    protected int getPayloadStart() {
        return 0;
    }

    protected int getPayloadEnd() {
        return this.bufsize;
    }

    protected abstract void internalWrite(byte[] var1, int var2, boolean var3) throws IOException;

    private void checkBuffer() throws IOException {
        if (this._position == this.getPayloadEnd()) {
            this.internalWrite(this._buffer, this._position, false);
            this._position = this.getPayloadStart();
        }
    }

    private void ensureBufferNotNull() {
        if (this._buffer == null) {
            this._buffer = new byte[this.bufsize];
            this._position = this.getPayloadStart();
        }
    }
}

