/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.util;

import com.github.libxjava.util.BasicEnumeration;
import java.util.NoSuchElementException;

public class BasicArrayList {
    private Object[] _data;
    private int _size;
    private int _modCount;

    public BasicArrayList() {
        this(10);
    }

    public BasicArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this._data = new Object[initialCapacity];
        this._size = 0;
        this._modCount = 0;
    }

    public boolean add(Object obj) {
        this.ensureCapacity(this._size + 1);
        this._data[this._size++] = obj;
        return true;
    }

    public void add(int index, Object obj) {
        this.checkIndex(index);
        this.ensureCapacity(this._size + 1);
        System.arraycopy(this._data, index, this._data, index + 1, this._size - index);
        this._data[index] = obj;
        ++this._size;
    }

    public void clear() {
        ++this._modCount;
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = null;
        }
        this._size = 0;
    }

    public boolean contains(Object obj) {
        return this.indexOf(obj) >= 0;
    }

    public void ensureCapacity(int minCapacity) {
        ++this._modCount;
        int oldCapacity = this._data.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            Object[] newData = new Object[newCapacity];
            System.arraycopy(this._data, 0, newData, 0, this._size);
            this._data = newData;
        }
    }

    public BasicEnumeration enumeration() {
        return new Enumerator(this._modCount);
    }

    public Object get(int index) {
        this.checkIndex(index);
        return this._data[index];
    }

    public int indexOf(Object obj) {
        if (obj == null) {
            for (int i = 0; i < this._size; ++i) {
                if (this._data[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this._size; ++i) {
                if (!obj.equals(this._data[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public int lastIndexOf(Object obj) {
        if (obj == null) {
            for (int i = this._size - 1; i >= 0; --i) {
                if (this._data[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this._size - 1; i >= 0; --i) {
                if (!obj.equals(this._data[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public void trimToSize() {
        ++this._modCount;
        if (this._size < this._data.length) {
            Object[] newData = new Object[this._size];
            System.arraycopy(this._data, 0, newData, 0, this._size);
            this._data = newData;
        }
    }

    public boolean remove(Object obj) {
        int index = this.indexOf(obj);
        if (index >= 0) {
            this.internalRemove(index);
            return true;
        }
        return false;
    }

    public Object remove(int index) {
        this.checkIndex(index);
        Object old = this._data[index];
        this.internalRemove(index);
        return old;
    }

    public Object set(int index, Object obj) {
        this.checkIndex(index);
        Object old = this._data[index];
        this._data[index] = obj;
        return old;
    }

    public int size() {
        return this._size;
    }

    public String toString() {
        if (this._size <= 0) {
            return "[]";
        }
        StringBuffer result = new StringBuffer();
        result.append('[');
        int last = this._size - 1;
        for (int i = 0; i <= last; ++i) {
            result.append(this._data[i] == this ? "(this List)" : this._data[i]);
            if (i >= last) continue;
            result.append(", ");
        }
        result.append(']');
        return result.toString();
    }

    private void checkIndex(int index) {
        if (index >= this._size) {
            throw new IndexOutOfBoundsException("index " + index + ", size " + this._size);
        }
    }

    private void internalRemove(int index) {
        ++this._modCount;
        int toMove = this._size - index - 1;
        if (toMove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, toMove);
        }
        this._data[--this._size] = null;
    }

    private final class Enumerator
    implements BasicEnumeration {
        private int _index = 0;
        private int _lastReturned = -1;
        private int _expectedModCount;

        protected Enumerator(int modCount) {
            this._expectedModCount = modCount;
        }

        public boolean hasMoreElements() {
            return this._index < BasicArrayList.this.size();
        }

        public Object nextElement() {
            this.ensureUnmodified();
            try {
                Object val = BasicArrayList.this.get(this._index);
                this._lastReturned = this._index++;
                return val;
            }
            catch (IndexOutOfBoundsException e) {
                this.ensureUnmodified();
                throw new NoSuchElementException("ArrayList Enumeration");
            }
        }

        public void remove() {
            if (this._lastReturned < 0) {
                throw new RuntimeException("illegal state");
            }
            this.ensureUnmodified();
            try {
                BasicArrayList.this.remove(this._lastReturned);
                --this._index;
                this._lastReturned = -1;
                this._expectedModCount = BasicArrayList.this._modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeException("concurrent modification");
            }
        }

        private void ensureUnmodified() {
            if (BasicArrayList.this._modCount != this._expectedModCount) {
                throw new RuntimeException("concurrent modification");
            }
        }
    }
}

