/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public final class PropertyUtil {
    public static Hashtable load(InputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        Hashtable result = new Hashtable();
        PropertyUtil.loadInto(result, input);
        return result;
    }

    public static void loadInto(Hashtable properties, InputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties table is null");
        }
        KeyValueReader reader = new KeyValueReader(input);
        while (reader.readPair()) {
            properties.put(reader.lastKey, reader.lastValue);
        }
    }

    private PropertyUtil() {
    }

    private static final class KeyValueReader {
        private InputStream _input;
        private byte[] _buffer;
        private int _off;
        private int _newLoad;
        private StringBuffer _builder;
        protected String lastKey;
        protected String lastValue;

        protected KeyValueReader(InputStream input) {
            this._input = input;
            this._buffer = new byte[512];
            this._off = 0;
            this._newLoad = 0;
            this._builder = new StringBuffer();
        }

        protected boolean readPair() throws IOException {
            this.lastKey = null;
            this.lastValue = null;
            block5: while (true) {
                if (this._off >= this._newLoad) {
                    this._newLoad = this._input.read(this._buffer);
                    if (this._newLoad < 0) {
                        if (this.lastKey != null) {
                            this.lastValue = this._builder.toString();
                            this._builder.setLength(0);
                            return true;
                        }
                        return false;
                    }
                    this._off = 0;
                }
                char ch = (char)(this._buffer[this._off++] & 0xFF);
                switch (ch) {
                    case '\r': {
                        continue block5;
                    }
                    case '=': {
                        if (this.lastKey != null) {
                            throw new IOException("unexpected character: =");
                        }
                        this.lastKey = this._builder.toString();
                        this._builder.setLength(0);
                        continue block5;
                    }
                    case '\n': {
                        if (this.lastKey == null) {
                            throw new IOException("unexpected end of line");
                        }
                        this.lastValue = this._builder.toString();
                        this._builder.setLength(0);
                        return true;
                    }
                }
                this._builder.append(ch);
            }
        }
    }
}

