/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.http.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import uk.co.mruoc.http.client.Headers;
import uk.co.mruoc.http.client.Method;
import uk.co.mruoc.http.client.Request;
import uk.co.mruoc.http.client.RequestConverter;

public class FakeApacheHttpClient
implements HttpClient {
    private final RequestConverter converter = new RequestConverter();
    private final List<Request> requests = new ArrayList<Request>();
    private HttpResponse response;
    private boolean throwIo;

    public HttpResponse execute(HttpUriRequest rawRequest) throws IOException {
        this.requests.add(this.converter.toRequest((HttpRequest)rawRequest));
        if (this.throwIo) {
            throw new IOException();
        }
        return this.response;
    }

    public void cannedResponse(int status) {
        this.cannedResponse(status, "");
    }

    public void cannedResponse(int status, String body) {
        this.cannedResponse(status, body, new Headers());
    }

    public void cannedResponse(int status, String body, Headers headers) {
        this.response = FakeApacheHttpClient.makeApacheResponse(status, body, headers);
    }

    public List<Request> allRequests() {
        return this.requests;
    }

    public String lastRequestUri() {
        return this.lastRequest().getRequestUri();
    }

    public String lastRequestBody() {
        return this.lastRequest().getBody();
    }

    public Method lastRequestMethod() {
        return this.lastRequest().getMethod();
    }

    public String lastRequestHeader(String name) {
        return this.lastRequest().getHeader(name);
    }

    public void throwsIoException() {
        this.throwIo = true;
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return null;
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        return null;
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return null;
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return null;
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return null;
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return null;
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return null;
    }

    public HttpParams getParams() {
        return null;
    }

    public ClientConnectionManager getConnectionManager() {
        return null;
    }

    Request lastRequest() {
        return this.requests.get(this.requests.size() - 1);
    }

    private static BasicHttpResponse makeApacheResponse(int status, String body, Headers headers) {
        try {
            BasicHttpResponse apacheResponse = new BasicHttpResponse((StatusLine)FakeApacheHttpClient.createStatus(status));
            apacheResponse.setEntity((HttpEntity)new StringEntity(body));
            FakeApacheHttpClient.setHeaders(apacheResponse, headers);
            return apacheResponse;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static BasicStatusLine createStatus(int statusCode) {
        return new BasicStatusLine(new ProtocolVersion("HTTP", 1, 1), statusCode, "OK");
    }

    private static void setHeaders(BasicHttpResponse apacheResponse, Headers headers) {
        for (String name : headers.getNames()) {
            apacheResponse.setHeader(name, headers.get(name));
        }
    }
}

