/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.http.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpMessage;
import org.apache.log4j.Logger;

public class Headers {
    private static final Logger LOG = Logger.getLogger(Headers.class);
    private final Map<String, String> values = new HashMap<String, String>();

    public Headers() {
    }

    public Headers(HttpMessage message) {
        for (Header header : message.getAllHeaders()) {
            this.add(header);
        }
    }

    public void add(Header header) {
        this.add(header.getName(), header.getValue());
    }

    public void add(String name, String value) {
        this.logAddHeader(name, value);
        this.values.put(name, value);
    }

    public String get(String name) {
        if (!this.headerExists(name)) {
            throw new HeaderNotFoundException(name);
        }
        return this.values.get(name);
    }

    public boolean headerExists(String name) {
        return this.values.containsKey(name);
    }

    public Set<String> getNames() {
        return this.values.keySet();
    }

    private void logAddHeader(String name, String value) {
        if (this.headerExists(name)) {
            this.logOverwriteMessage(name, value);
        } else {
            this.logAddMessage(name, value);
        }
    }

    private void logOverwriteMessage(String name, String value) {
        String oldValue = this.get(name);
        LOG.info((Object)("header " + name + " value " + oldValue + " being replaced with " + value));
    }

    private void logAddMessage(String name, String value) {
        LOG.info((Object)("adding header " + name + " with value " + value));
    }

    public static class HeaderNotFoundException
    extends RuntimeException {
        public HeaderNotFoundException(String headerName) {
            super(headerName);
        }
    }
}

