/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.http.client;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import uk.co.mruoc.http.client.Headers;
import uk.co.mruoc.http.client.HttpClientException;
import uk.co.mruoc.http.client.Method;
import uk.co.mruoc.http.client.Request;

public class RequestConverter {
    private static final Logger LOG = Logger.getLogger(Headers.class);

    public Request toRequest(HttpRequest apacheRequest) {
        return new Request.RequestBuilder().setUri(RequestConverter.extractUri(apacheRequest)).setMethod(RequestConverter.extractMethod(apacheRequest)).setBody(RequestConverter.extractBody(apacheRequest)).setHeaders(RequestConverter.extractHeaders(apacheRequest)).build();
    }

    private static String extractUri(HttpRequest request) {
        return request.getRequestLine().getUri();
    }

    private static Method extractMethod(HttpRequest request) {
        return Method.valueOf(request.getRequestLine().getMethod());
    }

    private static String extractBody(HttpRequest request) {
        try {
            HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)request;
            return EntityUtils.toString((HttpEntity)entityRequest.getEntity());
        }
        catch (ClassCastException e) {
            LOG.info((Object)"apache request does not have a body available", (Throwable)e);
            return "";
        }
        catch (IOException e) {
            throw new HttpClientException(e);
        }
    }

    private static Headers extractHeaders(HttpRequest request) {
        return new Headers((HttpMessage)request);
    }
}

