/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.http.client;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import uk.co.mruoc.http.client.Headers;
import uk.co.mruoc.http.client.Response;

public class ResponseConverter {
    public Response toResponse(HttpResponse apacheResponse) throws IOException {
        return new Response.ResponseBuilder().setStatusCode(ResponseConverter.extractStatusCode(apacheResponse)).setBody(ResponseConverter.extractBody(apacheResponse)).setHeaders(ResponseConverter.extractHeaders(apacheResponse)).build();
    }

    private static int extractStatusCode(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    private static String extractBody(HttpResponse response) throws IOException {
        if (response.getEntity() == null) {
            return "";
        }
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }

    private static Headers extractHeaders(HttpResponse response) {
        return new Headers((HttpMessage)response);
    }
}

