/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.http.client;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;
import uk.co.mruoc.http.client.BaseHttpClient;
import uk.co.mruoc.http.client.Headers;
import uk.co.mruoc.http.client.HttpClientException;
import uk.co.mruoc.http.client.Response;
import uk.co.mruoc.http.client.ResponseConverter;

public class SimpleHttpClient
extends BaseHttpClient {
    private static final Logger LOG = Logger.getLogger(SimpleHttpClient.class);
    private final ResponseConverter converter = new ResponseConverter();
    private final HttpClient client;

    public SimpleHttpClient() {
        this((HttpClient)HttpClientBuilder.create().build());
    }

    public SimpleHttpClient(HttpClient client) {
        this.client = client;
    }

    @Override
    public Response post(String endpoint, String entity, Headers headers) {
        HttpPost post = this.createPost(endpoint, entity, headers);
        return this.execute((HttpRequestBase)post);
    }

    @Override
    public Response put(String endpoint, String entity, Headers headers) {
        HttpPut put = this.createPut(endpoint, entity, headers);
        return this.execute((HttpRequestBase)put);
    }

    @Override
    public Response get(String endpoint, Headers headers) {
        HttpGet get = this.createGet(endpoint, headers);
        return this.execute((HttpRequestBase)get);
    }

    @Override
    public Response delete(String endpoint, Headers headers) {
        HttpDelete delete = this.createDelete(endpoint, headers);
        return this.execute((HttpRequestBase)delete);
    }

    protected Response execute(HttpRequestBase request) {
        try {
            LOG.info((Object)("performing " + request.getMethod() + " on uri " + request.getURI().toString()));
            HttpResponse rawResponse = this.client.execute((HttpUriRequest)request);
            Response response = this.converter.toResponse(rawResponse);
            return response;
        }
        catch (IOException e) {
            throw new HttpClientException(e);
        }
        finally {
            request.releaseConnection();
        }
    }

    private HttpPost createPost(String endpoint, String entity, Headers headers) {
        HttpPost post = new HttpPost(endpoint);
        post.setEntity(this.toJsonEntity(entity));
        this.addHeaders((HttpRequest)post, headers);
        return post;
    }

    private HttpPut createPut(String endpoint, String entity, Headers headers) {
        HttpPut put = new HttpPut(endpoint);
        put.setEntity(this.toJsonEntity(entity));
        this.addHeaders((HttpRequest)put, headers);
        return put;
    }

    private HttpGet createGet(String endpoint, Headers headers) {
        HttpGet get = new HttpGet(endpoint);
        headers.add("Accept", ContentType.APPLICATION_JSON.getMimeType());
        this.addHeaders((HttpRequest)get, headers);
        return get;
    }

    private HttpDelete createDelete(String endpoint, Headers headers) {
        HttpDelete delete = new HttpDelete(endpoint);
        this.addHeaders((HttpRequest)delete, headers);
        return delete;
    }

    private void addHeaders(HttpRequest request, Headers headers) {
        for (String name : headers.getNames()) {
            request.setHeader(name, headers.get(name));
        }
    }

    private HttpEntity toJsonEntity(String entity) {
        LOG.info((Object)("creating entity using json " + entity));
        return new StringEntity(entity, ContentType.APPLICATION_JSON);
    }
}

