/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;

public class MACResponse
extends TpmStructure {
    public byte[] outMAC;

    public MACResponse(byte[] _outMAC) {
        this.outMAC = _outMAC;
    }

    public MACResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.outMAC != null ? this.outMAC.length : 0, 2);
        buf.write(this.outMAC);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _outMACSize = buf.readInt(2);
        this.outMAC = new byte[_outMACSize];
        buf.readArrayOfInts(this.outMAC, 1, _outMACSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static MACResponse fromTpm(byte[] x) {
        MACResponse ret = new MACResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static MACResponse fromTpm(InByteBuf buf) {
        MACResponse ret = new MACResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_MAC_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "outMAC", this.outMAC);
    }
}

