/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_EO;
import tss.tpm.TPM_HANDLE;

public class TPM2_PolicyCounterTimer_REQUEST
extends TpmStructure {
    public TPM_HANDLE policySession;
    public byte[] operandB;
    public short offset;
    public TPM_EO operation;

    public TPM2_PolicyCounterTimer_REQUEST(TPM_HANDLE _policySession, byte[] _operandB, int _offset, TPM_EO _operation) {
        this.policySession = _policySession;
        this.operandB = _operandB;
        this.offset = (short)_offset;
        this.operation = _operation;
    }

    public TPM2_PolicyCounterTimer_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.policySession.toTpm(buf);
        buf.writeInt(this.operandB != null ? this.operandB.length : 0, 2);
        buf.write(this.operandB);
        buf.write(this.offset);
        this.operation.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.policySession = TPM_HANDLE.fromTpm(buf);
        int _operandBSize = buf.readInt(2);
        this.operandB = new byte[_operandBSize];
        buf.readArrayOfInts(this.operandB, 1, _operandBSize);
        this.offset = (short)buf.readInt(2);
        this.operation = TPM_EO.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_PolicyCounterTimer_REQUEST fromTpm(byte[] x) {
        TPM2_PolicyCounterTimer_REQUEST ret = new TPM2_PolicyCounterTimer_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_PolicyCounterTimer_REQUEST fromTpm(InByteBuf buf) {
        TPM2_PolicyCounterTimer_REQUEST ret = new TPM2_PolicyCounterTimer_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PolicyCounterTimer_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "policySession", this.policySession);
        _p.add(d, "byte", "operandB", this.operandB);
        _p.add(d, "ushort", "offset", this.offset);
        _p.add(d, "TPM_EO", "operation", this.operation);
    }
}

