/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_CAPABILITIES;
import tss.tpm.TPM_ECC_CURVE;

public class TPML_ECC_CURVE
extends TpmStructure
implements TPMU_CAPABILITIES {
    public TPM_ECC_CURVE[] eccCurves;

    public TPML_ECC_CURVE(TPM_ECC_CURVE[] _eccCurves) {
        this.eccCurves = _eccCurves;
    }

    public TPML_ECC_CURVE() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.eccCurves != null ? this.eccCurves.length : 0, 4);
        buf.writeArrayOfTpmObjects(this.eccCurves);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _count = buf.readInt(4);
        this.eccCurves = new TPM_ECC_CURVE[_count];
        for (int j = 0; j < _count; ++j) {
            this.eccCurves[j] = TPM_ECC_CURVE.fromTpm(buf);
        }
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPML_ECC_CURVE fromTpm(byte[] x) {
        TPML_ECC_CURVE ret = new TPML_ECC_CURVE();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPML_ECC_CURVE fromTpm(InByteBuf buf) {
        TPML_ECC_CURVE ret = new TPML_ECC_CURVE();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPML_ECC_CURVE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ECC_CURVE", "eccCurves", this.eccCurves);
    }
}

