/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_CAPABILITIES;
import tss.tpm.TPM_HANDLE;

public class TPML_HANDLE
extends TpmStructure
implements TPMU_CAPABILITIES {
    public TPM_HANDLE[] handle;

    public TPML_HANDLE(TPM_HANDLE[] _handle) {
        this.handle = _handle;
    }

    public TPML_HANDLE() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.handle != null ? this.handle.length : 0, 4);
        buf.writeArrayOfTpmObjects(this.handle);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _count = buf.readInt(4);
        this.handle = new TPM_HANDLE[_count];
        for (int j = 0; j < _count; ++j) {
            this.handle[j] = new TPM_HANDLE();
        }
        buf.readArrayOfTpmObjects(this.handle, _count);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPML_HANDLE fromTpm(byte[] x) {
        TPML_HANDLE ret = new TPML_HANDLE();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPML_HANDLE fromTpm(InByteBuf buf) {
        TPML_HANDLE ret = new TPML_HANDLE();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPML_HANDLE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "handle", this.handle);
    }
}

