/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Collection;
import tss.InByteBuf;
import tss.TpmEnum;
import tss.tpm.ImplementationConstants;
import tss.tpm.Logic;
import tss.tpm.TPM_ALG_ID;

public final class Implementation
extends TpmEnum<Implementation> {
    private static TpmEnum.ValueMap<Implementation> _ValueMap = new TpmEnum.ValueMap();
    public static final Implementation FIELD_UPGRADE_IMPLEMENTED = new Implementation(Logic.NO.toInt(), _N.FIELD_UPGRADE_IMPLEMENTED);
    public static final Implementation RADIX_BITS = new Implementation(32, _N.RADIX_BITS);
    public static final Implementation HASH_ALIGNMENT = new Implementation(4, _N.HASH_ALIGNMENT);
    public static final Implementation SYMMETRIC_ALIGNMENT = new Implementation(4, _N.SYMMETRIC_ALIGNMENT);
    public static final Implementation HASH_LIB = new Implementation(ImplementationConstants.OSSL.toInt(), _N.HASH_LIB);
    public static final Implementation SYM_LIB = new Implementation(ImplementationConstants.OSSL.toInt(), _N.SYM_LIB);
    public static final Implementation MATH_LIB = new Implementation(ImplementationConstants.OSSL.toInt(), _N.MATH_LIB);
    public static final Implementation IMPLEMENTATION_PCR = new Implementation(24, _N.IMPLEMENTATION_PCR);
    public static final Implementation PLATFORM_PCR = new Implementation(24, _N.PLATFORM_PCR);
    public static final Implementation DRTM_PCR = new Implementation(17, _N.DRTM_PCR);
    public static final Implementation HCRTM_PCR = new Implementation(0, _N.HCRTM_PCR);
    public static final Implementation NUM_LOCALITIES = new Implementation(5, _N.NUM_LOCALITIES);
    public static final Implementation MAX_HANDLE_NUM = new Implementation(3, _N.MAX_HANDLE_NUM);
    public static final Implementation MAX_ACTIVE_SESSIONS = new Implementation(64, _N.MAX_ACTIVE_SESSIONS);
    public static final Implementation MAX_LOADED_SESSIONS = new Implementation(3, _N.MAX_LOADED_SESSIONS);
    public static final Implementation MAX_SESSION_NUM = new Implementation(3, _N.MAX_SESSION_NUM);
    public static final Implementation MAX_LOADED_OBJECTS = new Implementation(3, _N.MAX_LOADED_OBJECTS);
    public static final Implementation MIN_EVICT_OBJECTS = new Implementation(2, _N.MIN_EVICT_OBJECTS);
    public static final Implementation PCR_SELECT_MIN = new Implementation((PLATFORM_PCR.toInt() + 7) / 8, _N.PCR_SELECT_MIN);
    public static final Implementation PCR_SELECT_MAX = new Implementation((IMPLEMENTATION_PCR.toInt() + 7) / 8, _N.PCR_SELECT_MAX);
    public static final Implementation NUM_POLICY_PCR_GROUP = new Implementation(1, _N.NUM_POLICY_PCR_GROUP);
    public static final Implementation NUM_AUTHVALUE_PCR_GROUP = new Implementation(1, _N.NUM_AUTHVALUE_PCR_GROUP);
    public static final Implementation MAX_CONTEXT_SIZE = new Implementation(2474, _N.MAX_CONTEXT_SIZE);
    public static final Implementation MAX_DIGEST_BUFFER = new Implementation(1024, _N.MAX_DIGEST_BUFFER);
    public static final Implementation MAX_NV_INDEX_SIZE = new Implementation(2048, _N.MAX_NV_INDEX_SIZE);
    public static final Implementation MAX_NV_BUFFER_SIZE = new Implementation(1024, _N.MAX_NV_BUFFER_SIZE);
    public static final Implementation MAX_CAP_BUFFER = new Implementation(1024, _N.MAX_CAP_BUFFER);
    public static final Implementation NV_MEMORY_SIZE = new Implementation(16384, _N.NV_MEMORY_SIZE);
    public static final Implementation MIN_COUNTER_INDICES = new Implementation(8, _N.MIN_COUNTER_INDICES);
    public static final Implementation NUM_STATIC_PCR = new Implementation(16, _N.NUM_STATIC_PCR);
    public static final Implementation MAX_ALG_LIST_SIZE = new Implementation(64, _N.MAX_ALG_LIST_SIZE);
    public static final Implementation PRIMARY_SEED_SIZE = new Implementation(32, _N.PRIMARY_SEED_SIZE);
    public static final Implementation CONTEXT_ENCRYPT_ALGORITHM = new Implementation(TPM_ALG_ID.AES.toInt(), _N.CONTEXT_ENCRYPT_ALGORITHM);
    public static final Implementation NV_CLOCK_UPDATE_INTERVAL = new Implementation(12, _N.NV_CLOCK_UPDATE_INTERVAL);
    public static final Implementation NUM_POLICY_PCR = new Implementation(1, _N.NUM_POLICY_PCR);
    public static final Implementation MAX_COMMAND_SIZE = new Implementation(4096, _N.MAX_COMMAND_SIZE);
    public static final Implementation MAX_RESPONSE_SIZE = new Implementation(4096, _N.MAX_RESPONSE_SIZE);
    public static final Implementation ORDERLY_BITS = new Implementation(8, _N.ORDERLY_BITS);
    public static final Implementation MAX_SYM_DATA = new Implementation(128, _N.MAX_SYM_DATA);
    public static final Implementation MAX_RNG_ENTROPY_SIZE = new Implementation(64, _N.MAX_RNG_ENTROPY_SIZE);
    public static final Implementation RAM_INDEX_SPACE = new Implementation(512, _N.RAM_INDEX_SPACE);
    public static final Implementation RSA_DEFAULT_PUBLIC_EXPONENT = new Implementation(65537, _N.RSA_DEFAULT_PUBLIC_EXPONENT);
    public static final Implementation ENABLE_PCR_NO_INCREMENT = new Implementation(Logic.YES.toInt(), _N.ENABLE_PCR_NO_INCREMENT);
    public static final Implementation CRT_FORMAT_RSA = new Implementation(Logic.YES.toInt(), _N.CRT_FORMAT_RSA);
    public static final Implementation VENDOR_COMMAND_COUNT = new Implementation(0, _N.VENDOR_COMMAND_COUNT);
    public static final Implementation PRIVATE_VENDOR_SPECIFIC_BYTES = new Implementation(ImplementationConstants.MAX_RSA_KEY_BYTES.toInt() / 2 * (3 + CRT_FORMAT_RSA.toInt() * 2), _N.PRIVATE_VENDOR_SPECIFIC_BYTES);
    public static final Implementation MAX_VENDOR_BUFFER_SIZE = new Implementation(1024, _N.MAX_VENDOR_BUFFER_SIZE);

    public Implementation(int value) {
        super(value, _ValueMap);
    }

    public static Implementation fromInt(int value) {
        return TpmEnum.fromInt(value, _ValueMap, Implementation.class);
    }

    public static Implementation fromTpm(byte[] buf) {
        return TpmEnum.fromTpm(buf, _ValueMap, Implementation.class);
    }

    public static Implementation fromTpm(InByteBuf buf) {
        return TpmEnum.fromTpm(buf, _ValueMap, Implementation.class);
    }

    public _N asEnum() {
        return (_N)this.NameAsEnum;
    }

    public static Collection<Implementation> values() {
        return _ValueMap.values();
    }

    private Implementation(int value, _N nameAsEnum) {
        super(value, nameAsEnum, _ValueMap);
    }

    private Implementation(int value, _N nameAsEnum, boolean noConvFromInt) {
        super(value, nameAsEnum, null);
    }

    @Override
    protected int wireSize() {
        return 4;
    }

    public static enum _N {
        FIELD_UPGRADE_IMPLEMENTED,
        RADIX_BITS,
        HASH_ALIGNMENT,
        SYMMETRIC_ALIGNMENT,
        HASH_LIB,
        SYM_LIB,
        MATH_LIB,
        IMPLEMENTATION_PCR,
        PLATFORM_PCR,
        DRTM_PCR,
        HCRTM_PCR,
        NUM_LOCALITIES,
        MAX_HANDLE_NUM,
        MAX_ACTIVE_SESSIONS,
        MAX_LOADED_SESSIONS,
        MAX_SESSION_NUM,
        MAX_LOADED_OBJECTS,
        MIN_EVICT_OBJECTS,
        PCR_SELECT_MIN,
        PCR_SELECT_MAX,
        NUM_POLICY_PCR_GROUP,
        NUM_AUTHVALUE_PCR_GROUP,
        MAX_CONTEXT_SIZE,
        MAX_DIGEST_BUFFER,
        MAX_NV_INDEX_SIZE,
        MAX_NV_BUFFER_SIZE,
        MAX_CAP_BUFFER,
        NV_MEMORY_SIZE,
        MIN_COUNTER_INDICES,
        NUM_STATIC_PCR,
        MAX_ALG_LIST_SIZE,
        PRIMARY_SEED_SIZE,
        CONTEXT_ENCRYPT_ALGORITHM,
        NV_CLOCK_UPDATE_INTERVAL,
        NUM_POLICY_PCR,
        MAX_COMMAND_SIZE,
        MAX_RESPONSE_SIZE,
        ORDERLY_BITS,
        MAX_SYM_DATA,
        MAX_RNG_ENTROPY_SIZE,
        RAM_INDEX_SPACE,
        RSA_DEFAULT_PUBLIC_EXPONENT,
        ENABLE_PCR_NO_INCREMENT,
        CRT_FORMAT_RSA,
        VENDOR_COMMAND_COUNT,
        PRIVATE_VENDOR_SPECIFIC_BYTES,
        MAX_VENDOR_BUFFER_SIZE;

    }
}

