/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_CONTEXT_DATA;

public class TPM2B_CONTEXT_DATA
extends TpmStructure {
    public TPMS_CONTEXT_DATA buffer;

    public TPM2B_CONTEXT_DATA(TPMS_CONTEXT_DATA _buffer) {
        this.buffer = _buffer;
    }

    public TPM2B_CONTEXT_DATA() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.buffer != null ? this.buffer.toTpm().length : 0, 2);
        if (this.buffer != null) {
            this.buffer.toTpm(buf);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _size = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _size));
        this.buffer = TPMS_CONTEXT_DATA.fromTpm(buf);
        buf.structSize.pop();
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2B_CONTEXT_DATA fromTpm(byte[] x) {
        TPM2B_CONTEXT_DATA ret = new TPM2B_CONTEXT_DATA();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2B_CONTEXT_DATA fromTpm(InByteBuf buf) {
        TPM2B_CONTEXT_DATA ret = new TPM2B_CONTEXT_DATA();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2B_CONTEXT_DATA");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMS_CONTEXT_DATA", "buffer", this.buffer);
    }
}

