/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_PCR_SELECTION;
import tss.tpm.TPM_HANDLE;

public class TPM2_PolicyPCR_REQUEST
extends TpmStructure {
    public TPM_HANDLE policySession;
    public byte[] pcrDigest;
    public TPMS_PCR_SELECTION[] pcrs;

    public TPM2_PolicyPCR_REQUEST(TPM_HANDLE _policySession, byte[] _pcrDigest, TPMS_PCR_SELECTION[] _pcrs) {
        this.policySession = _policySession;
        this.pcrDigest = _pcrDigest;
        this.pcrs = _pcrs;
    }

    public TPM2_PolicyPCR_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.policySession.toTpm(buf);
        buf.writeInt(this.pcrDigest != null ? this.pcrDigest.length : 0, 2);
        if (this.pcrDigest != null) {
            buf.write(this.pcrDigest);
        }
        buf.writeInt(this.pcrs != null ? this.pcrs.length : 0, 4);
        if (this.pcrs != null) {
            buf.writeArrayOfTpmObjects(this.pcrs);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.policySession = TPM_HANDLE.fromTpm(buf);
        int _pcrDigestSize = buf.readInt(2);
        this.pcrDigest = new byte[_pcrDigestSize];
        buf.readArrayOfInts(this.pcrDigest, 1, _pcrDigestSize);
        int _pcrsCount = buf.readInt(4);
        this.pcrs = new TPMS_PCR_SELECTION[_pcrsCount];
        for (int j = 0; j < _pcrsCount; ++j) {
            this.pcrs[j] = new TPMS_PCR_SELECTION();
        }
        buf.readArrayOfTpmObjects(this.pcrs, _pcrsCount);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_PolicyPCR_REQUEST fromTpm(byte[] x) {
        TPM2_PolicyPCR_REQUEST ret = new TPM2_PolicyPCR_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_PolicyPCR_REQUEST fromTpm(InByteBuf buf) {
        TPM2_PolicyPCR_REQUEST ret = new TPM2_PolicyPCR_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PolicyPCR_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "policySession", this.policySession);
        _p.add(d, "byte", "pcrDigest", this.pcrDigest);
        _p.add(d, "TPMS_PCR_SELECTION", "pcrs", this.pcrs);
    }
}

