/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMA_NV;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPMS_NV_PUBLIC
extends TpmStructure {
    public TPM_HANDLE nvIndex;
    public TPM_ALG_ID nameAlg;
    public TPMA_NV attributes;
    public byte[] authPolicy;
    public short dataSize;

    public TPMS_NV_PUBLIC(TPM_HANDLE _nvIndex, TPM_ALG_ID _nameAlg, TPMA_NV _attributes, byte[] _authPolicy, int _dataSize) {
        this.nvIndex = _nvIndex;
        this.nameAlg = _nameAlg;
        this.attributes = _attributes;
        this.authPolicy = _authPolicy;
        this.dataSize = (short)_dataSize;
    }

    public TPMS_NV_PUBLIC() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.nvIndex.toTpm(buf);
        this.nameAlg.toTpm(buf);
        this.attributes.toTpm(buf);
        buf.writeInt(this.authPolicy != null ? this.authPolicy.length : 0, 2);
        if (this.authPolicy != null) {
            buf.write(this.authPolicy);
        }
        buf.write(this.dataSize);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.nvIndex = TPM_HANDLE.fromTpm(buf);
        this.nameAlg = TPM_ALG_ID.fromTpm(buf);
        int _attributes = buf.readInt(4);
        this.attributes = TPMA_NV.fromInt(_attributes);
        int _authPolicySize = buf.readInt(2);
        this.authPolicy = new byte[_authPolicySize];
        buf.readArrayOfInts(this.authPolicy, 1, _authPolicySize);
        this.dataSize = (short)buf.readInt(2);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_NV_PUBLIC fromTpm(byte[] x) {
        TPMS_NV_PUBLIC ret = new TPMS_NV_PUBLIC();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_NV_PUBLIC fromTpm(InByteBuf buf) {
        TPMS_NV_PUBLIC ret = new TPMS_NV_PUBLIC();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_NV_PUBLIC");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "nvIndex", this.nvIndex);
        _p.add(d, "TPM_ALG_ID", "nameAlg", this.nameAlg);
        _p.add(d, "TPMA_NV", "attributes", this.attributes);
        _p.add(d, "byte", "authPolicy", this.authPolicy);
        _p.add(d, "ushort", "dataSize", this.dataSize);
    }
}

