/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_TIME_INFO;
import tss.tpm.TPMU_ATTEST;

public class TPMS_TIME_ATTEST_INFO
extends TpmStructure
implements TPMU_ATTEST {
    public TPMS_TIME_INFO time;
    public long firmwareVersion;

    public TPMS_TIME_ATTEST_INFO(TPMS_TIME_INFO _time, long _firmwareVersion) {
        this.time = _time;
        this.firmwareVersion = _firmwareVersion;
    }

    public TPMS_TIME_ATTEST_INFO() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.time.toTpm(buf);
        buf.write(this.firmwareVersion);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.time = TPMS_TIME_INFO.fromTpm(buf);
        this.firmwareVersion = buf.readLong();
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_TIME_ATTEST_INFO fromTpm(byte[] x) {
        TPMS_TIME_ATTEST_INFO ret = new TPMS_TIME_ATTEST_INFO();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_TIME_ATTEST_INFO fromTpm(InByteBuf buf) {
        TPMS_TIME_ATTEST_INFO ret = new TPMS_TIME_ATTEST_INFO();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_TIME_ATTEST_INFO");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMS_TIME_INFO", "time", this.time);
        _p.add(d, "ulong", "firmwareVersion", this.firmwareVersion);
    }
}

