/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_NULL_SIG_SCHEME;
import tss.tpm.TPMS_SCHEME_HASH;
import tss.tpm.TPMS_SCHEME_HMAC;
import tss.tpm.TPMS_SIG_SCHEME_ECDAA;
import tss.tpm.TPMS_SIG_SCHEME_ECDSA;
import tss.tpm.TPMS_SIG_SCHEME_ECSCHNORR;
import tss.tpm.TPMS_SIG_SCHEME_RSAPSS;
import tss.tpm.TPMS_SIG_SCHEME_RSASSA;
import tss.tpm.TPMS_SIG_SCHEME_SM2;
import tss.tpm.TPMU_SIG_SCHEME;
import tss.tpm.TPM_ALG_ID;

public class TPMT_SIG_SCHEME
extends TpmStructure {
    public TPMU_SIG_SCHEME details;

    public TPMT_SIG_SCHEME(TPMU_SIG_SCHEME _details) {
        this.details = _details;
    }

    public TPMT_SIG_SCHEME() {
    }

    public int GetUnionSelector_details() {
        if (this.details instanceof TPMS_SIG_SCHEME_RSASSA) {
            return 20;
        }
        if (this.details instanceof TPMS_SIG_SCHEME_RSAPSS) {
            return 22;
        }
        if (this.details instanceof TPMS_SIG_SCHEME_ECDSA) {
            return 24;
        }
        if (this.details instanceof TPMS_SIG_SCHEME_ECDAA) {
            return 26;
        }
        if (this.details instanceof TPMS_SIG_SCHEME_SM2) {
            return 27;
        }
        if (this.details instanceof TPMS_SIG_SCHEME_ECSCHNORR) {
            return 28;
        }
        if (this.details instanceof TPMS_SCHEME_HMAC) {
            return 5;
        }
        if (this.details instanceof TPMS_SCHEME_HASH) {
            return Short.MAX_VALUE;
        }
        if (this.details instanceof TPMS_NULL_SIG_SCHEME) {
            return 16;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.GetUnionSelector_details(), 2);
        this.details.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _scheme = buf.readInt(2);
        this.details = null;
        if (_scheme == TPM_ALG_ID.RSASSA.toInt()) {
            this.details = new TPMS_SIG_SCHEME_RSASSA();
        } else if (_scheme == TPM_ALG_ID.RSAPSS.toInt()) {
            this.details = new TPMS_SIG_SCHEME_RSAPSS();
        } else if (_scheme == TPM_ALG_ID.ECDSA.toInt()) {
            this.details = new TPMS_SIG_SCHEME_ECDSA();
        } else if (_scheme == TPM_ALG_ID.ECDAA.toInt()) {
            this.details = new TPMS_SIG_SCHEME_ECDAA();
        } else if (_scheme == TPM_ALG_ID.HMAC.toInt()) {
            this.details = new TPMS_SCHEME_HMAC();
        } else if (_scheme == TPM_ALG_ID.ANY.toInt()) {
            this.details = new TPMS_SCHEME_HASH();
        } else if (_scheme == TPM_ALG_ID.NULL.toInt()) {
            this.details = new TPMS_NULL_SIG_SCHEME();
        }
        if (this.details == null) {
            throw new RuntimeException("Unexpected type selector " + TPM_ALG_ID.fromInt(_scheme).name());
        }
        this.details.initFromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMT_SIG_SCHEME fromTpm(byte[] x) {
        TPMT_SIG_SCHEME ret = new TPMT_SIG_SCHEME();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMT_SIG_SCHEME fromTpm(InByteBuf buf) {
        TPMT_SIG_SCHEME ret = new TPMT_SIG_SCHEME();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMT_SIG_SCHEME");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMU_SIG_SCHEME", "details", this.details);
    }
}

