/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.util.thread;

import com.mpush.client.ClientConfig;
import com.mpush.util.thread.NamedThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ExecutorManager {
    public static final String THREAD_NAME_PREFIX = "mp-client-";
    public static final String WRITE_THREAD_NAME = "mp-client-write-t";
    public static final String READ_THREAD_NAME = "mp-client-read-t";
    public static final String DISPATCH_THREAD_NAME = "mp-client-dispatch-t";
    public static final String START_THREAD_NAME = "mp-client-start-t";
    public static final String HTTP_THREAD_NAME = "mp-client-http-t";
    public static final ExecutorManager INSTANCE = new ExecutorManager();
    private ThreadPoolExecutor writeThread;
    private ThreadPoolExecutor dispatchThread;
    private ThreadPoolExecutor startThread;
    private ScheduledExecutorService httpRequestThread;

    public ThreadPoolExecutor getWriteThread() {
        if (this.writeThread == null || this.writeThread.isShutdown()) {
            this.writeThread = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100), new NamedThreadFactory(WRITE_THREAD_NAME), new RejectedHandler());
        }
        return this.writeThread;
    }

    public ThreadPoolExecutor getDispatchThread() {
        if (this.dispatchThread == null || this.dispatchThread.isShutdown()) {
            this.dispatchThread = new ThreadPoolExecutor(2, 4, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100), new NamedThreadFactory(DISPATCH_THREAD_NAME), new RejectedHandler());
        }
        return this.dispatchThread;
    }

    public ThreadPoolExecutor getStartThread() {
        if (this.startThread == null || this.startThread.isShutdown()) {
            this.startThread = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1), new NamedThreadFactory(START_THREAD_NAME), new RejectedHandler());
        }
        return this.startThread;
    }

    public ScheduledExecutorService getHttpRequestThread() {
        if (this.httpRequestThread == null || this.httpRequestThread.isShutdown()) {
            this.httpRequestThread = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory(HTTP_THREAD_NAME), new RejectedHandler());
        }
        return this.httpRequestThread;
    }

    public synchronized void shutdown() {
        if (this.writeThread != null) {
            this.writeThread.shutdownNow();
            this.writeThread = null;
        }
        if (this.dispatchThread != null) {
            this.dispatchThread.shutdownNow();
            this.dispatchThread = null;
        }
        if (this.startThread != null) {
            this.startThread.shutdownNow();
            this.startThread = null;
        }
        if (this.httpRequestThread != null) {
            this.httpRequestThread.shutdownNow();
            this.httpRequestThread = null;
        }
    }

    public static boolean isMPThread() {
        return Thread.currentThread().getName().startsWith(THREAD_NAME_PREFIX);
    }

    private static class RejectedHandler
    implements RejectedExecutionHandler {
        private RejectedHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            ClientConfig.I.getLogger().w("a task was rejected execute=%s", executor);
        }
    }
}

