/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.client;

import com.mpush.api.Logger;
import com.mpush.api.http.HttpCallback;
import com.mpush.api.http.HttpRequest;
import com.mpush.api.http.HttpResponse;
import com.mpush.client.ClientConfig;
import com.mpush.util.thread.ExecutorManager;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class HttpRequestQueue {
    private final Map<Integer, RequestTask> queue = new ConcurrentHashMap<Integer, RequestTask>();
    private final ScheduledExecutorService timer = ExecutorManager.INSTANCE.getHttpRequestThread();
    private final Executor executor = ExecutorManager.INSTANCE.getDispatchThread();
    private final HttpResponse response408 = new HttpResponse(408, "Request Timeout", null, null);
    private final Callable<HttpResponse> NONE = new Callable<HttpResponse>(){

        @Override
        public HttpResponse call() throws Exception {
            return HttpRequestQueue.this.response408;
        }
    };
    private final Logger logger = ClientConfig.I.getLogger();

    public Future<HttpResponse> add(int sessionId, HttpRequest request) {
        RequestTask task = new RequestTask(sessionId, request);
        this.queue.put(sessionId, task);
        task.future = this.timer.schedule(task, (long)task.timeout, TimeUnit.MILLISECONDS);
        return task;
    }

    public RequestTask getAndRemove(int sessionId) {
        return this.queue.remove(sessionId);
    }

    public final class RequestTask
    extends FutureTask<HttpResponse>
    implements Runnable {
        private HttpCallback callback;
        private final String uri;
        private final int timeout;
        private final long sendTime;
        private final int sessionId;
        private Future<?> future;

        private RequestTask(int sessionId, HttpRequest request) {
            super(HttpRequestQueue.this.NONE);
            this.callback = request.getCallback();
            this.timeout = request.getTimeout();
            this.uri = request.uri;
            this.sendTime = System.currentTimeMillis();
            this.sessionId = sessionId;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean success = super.cancel(mayInterruptIfRunning);
            if (success && this.future.cancel(true)) {
                HttpRequestQueue.this.queue.remove(this.sessionId);
                if (this.callback != null) {
                    HttpRequestQueue.this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            RequestTask.this.callback.onCancelled();
                        }
                    });
                    this.callback = null;
                }
            }
            HttpRequestQueue.this.logger.d("one request task cancelled, sessionId=%d, costTime=%d, uri=%s", this.sessionId, System.currentTimeMillis() - this.sendTime, this.uri);
            return success;
        }

        @Override
        public void run() {
            HttpRequestQueue.this.queue.remove(this.sessionId);
            this.setResponse(HttpRequestQueue.this.response408);
        }

        public void setResponse(HttpResponse response) {
            if (this.future.cancel(true)) {
                this.set(response);
                if (this.callback != null) {
                    this.callback.onResponse(response);
                }
                this.callback = null;
            }
            HttpRequestQueue.this.logger.d("one request task end, sessionId=%d, costTime=%d, response=%d, uri=%s", this.sessionId, System.currentTimeMillis() - this.sendTime, response.statusCode, this.uri);
        }
    }
}

