/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.message;

import com.mpush.api.connection.Connection;
import com.mpush.api.protocol.Packet;
import com.mpush.message.BaseMessage;
import com.mpush.message.ByteBufMessage;
import com.mpush.util.ByteBuf;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class HandshakeOkMessage
extends ByteBufMessage {
    public byte[] serverKey;
    public int heartbeat;
    public String sessionId;
    public long expireTime;

    public HandshakeOkMessage(Packet message, Connection connection) {
        super(message, connection);
    }

    @Override
    public void decode(ByteBuffer body) {
        this.serverKey = this.decodeBytes(body);
        this.heartbeat = this.decodeInt(body);
        this.sessionId = this.decodeString(body);
        this.expireTime = this.decodeLong(body);
    }

    @Override
    public void encode(ByteBuf body) {
        this.encodeBytes(body, this.serverKey);
        this.encodeInt(body, this.heartbeat);
        this.encodeString(body, this.sessionId);
        this.encodeLong(body, this.expireTime);
    }

    public static HandshakeOkMessage from(BaseMessage src) {
        return new HandshakeOkMessage(src.createResponse(), src.connection);
    }

    public HandshakeOkMessage setServerKey(byte[] serverKey) {
        this.serverKey = serverKey;
        return this;
    }

    public HandshakeOkMessage setHeartbeat(int heartbeat) {
        this.heartbeat = heartbeat;
        return this;
    }

    public HandshakeOkMessage setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public HandshakeOkMessage setExpireTime(long expireTime) {
        this.expireTime = expireTime;
        return this;
    }

    @Override
    public String toString() {
        return "HandshakeOkMessage{serverKey=" + Arrays.toString(this.serverKey) + ", heartbeat=" + this.heartbeat + ", sessionId='" + this.sessionId + '\'' + ", expireTime=" + this.expireTime + '}';
    }
}

