/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.message;

import com.mpush.api.connection.Connection;
import com.mpush.api.protocol.Command;
import com.mpush.api.protocol.Packet;
import com.mpush.message.ByteBufMessage;
import com.mpush.util.ByteBuf;
import com.mpush.util.MPUtils;
import java.nio.ByteBuffer;
import java.util.Map;

public final class HttpRequestMessage
extends ByteBufMessage {
    public byte method;
    public String uri;
    public Map<String, String> headers;
    public byte[] body;

    public HttpRequestMessage(Connection connection) {
        super(new Packet(Command.HTTP_PROXY, HttpRequestMessage.genSessionId()), connection);
    }

    public HttpRequestMessage(Packet message, Connection connection) {
        super(message, connection);
    }

    @Override
    public void decode(ByteBuffer body) {
        this.method = this.decodeByte(body);
        this.uri = this.decodeString(body);
        this.headers = MPUtils.headerFromString(this.decodeString(body));
        this.body = this.decodeBytes(body);
    }

    @Override
    public void encode(ByteBuf body) {
        this.encodeByte(body, this.method);
        this.encodeString(body, this.uri);
        this.encodeString(body, MPUtils.headerToString(this.headers));
        this.encodeBytes(body, this.body);
    }

    public String getMethod() {
        switch (this.method) {
            case 0: {
                return "GET";
            }
            case 1: {
                return "POST";
            }
            case 2: {
                return "PUT";
            }
            case 3: {
                return "DELETE";
            }
        }
        return "GET";
    }
}

