/*
 * Decompiled with CFR 0.152.
 */
package com.mwt.explorers;

import com.mwt.explorers.BootstrapExplorer;
import com.mwt.explorers.Explorer;
import com.mwt.explorers.utilities.ExplorerInformation;
import com.mwt.explorers.utilities.FixedPolicy;
import com.mwt.explorers.utilities.FixedVariableActionContext;
import com.mwt.policies.Policy;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class BootstrapExplorerTest {
    private final ExplorerInformation<String> stringExInfo = new ExplorerInformation(8);
    private final ExplorerInformation<FixedVariableActionContext> varExInfo = new ExplorerInformation(8);
    private final List<Policy<String>> stringPolicies = new ArrayList<Policy<String>>();
    private final List<Policy<FixedVariableActionContext>> varPolicies = new ArrayList<Policy<FixedVariableActionContext>>();

    @Before
    public void setup() {
        for (int i = 6; i < 9; ++i) {
            this.stringPolicies.add(new FixedPolicy(i));
            this.varPolicies.add(new FixedPolicy(i - 1));
        }
    }

    @Test
    public void fixedAction() {
        BootstrapExplorer explorer = new BootstrapExplorer(this.stringPolicies, 10);
        String context = "context";
        int action = this.stringExInfo.mwt.chooseAction((Explorer)explorer, "abc", (Object)context);
        Assert.assertEquals((int)8, (int)action);
        Assert.assertEquals((String)("8 abc 0.33333 | " + context), (String)this.stringExInfo.recorder.getRecording().trim());
    }

    @Test
    public void variableAction() {
        BootstrapExplorer explorer = new BootstrapExplorer(this.varPolicies, 10);
        FixedVariableActionContext context = new FixedVariableActionContext(10);
        int action = this.varExInfo.mwt.chooseAction((Explorer)explorer, "abc", (Object)context);
        Assert.assertEquals((int)7, (int)action);
        Assert.assertEquals((String)("7 abc 0.33333 | " + context), (String)this.varExInfo.recorder.getRecording().trim());
    }
}

