/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.design;

import internal.nbbrd.design.proc.Elements2;
import internal.nbbrd.design.proc.ExecutableRules;
import internal.nbbrd.design.proc.Processing;
import internal.nbbrd.design.proc.Rule;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import nbbrd.design.StringValue;

@SupportedAnnotationTypes(value={"nbbrd.design.StringValue"})
public class StringValueProcessor
extends AbstractProcessor {
    private static final Rule<TypeElement> HAS_PARSE_METHOD = Rule.of(StringValueProcessor::hasParseMethod, "'%s' must have a parser");
    private static final Rule<TypeElement> HAS_FORMAT_METHOD = Rule.of(StringValueProcessor::hasFormatMethod, "'%s' must have a formatter");
    private static final Rule<TypeElement> IS_STRING_VALUE = Rule.on(TypeElement.class).and(HAS_PARSE_METHOD).and(HAS_FORMAT_METHOD);

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return Processing.of(IS_STRING_VALUE).process(annotations, roundEnv, this.processingEnv);
    }

    private static boolean hasParseMethod(ProcessingEnvironment env, TypeElement type) {
        Rule<ExecutableElement> isParseMethod = StringValueProcessor.getIsParseMethod(type.getAnnotation(StringValue.class));
        return Elements2.methodsIn(type).anyMatch(isParseMethod.asPredicate(env));
    }

    private static Rule<ExecutableElement> getIsParseMethod(StringValue annotation) {
        return Rule.on(ExecutableElement.class).and(Rule.isNamed(annotation.parseMethodName())).and(Rule.is(Modifier.PUBLIC)).and(Rule.is(Modifier.STATIC)).and(ExecutableRules.returnsEnclosing()).and(ExecutableRules.hasParametersThat(Rule.is(CharSequence.class))).and(ExecutableRules.hasNoCheckedException());
    }

    private static boolean hasFormatMethod(ProcessingEnvironment env, TypeElement type) {
        Rule<ExecutableElement> isFormatMethod = StringValueProcessor.getIsFormatMethod(type.getAnnotation(StringValue.class));
        return Elements2.methodsIn(type).anyMatch(isFormatMethod.asPredicate(env));
    }

    private static Rule<ExecutableElement> getIsFormatMethod(StringValue annotation) {
        return Rule.on(ExecutableElement.class).and(Rule.isNamed(annotation.formatMethodName())).and(Rule.is(Modifier.PUBLIC)).and(Rule.isNot(Modifier.STATIC)).and(ExecutableRules.returnsTypeThat(Rule.is(String.class))).and(ExecutableRules.hasNoParameter()).and(ExecutableRules.hasNoCheckedException());
    }
}

