/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.design.proc;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public final class Processors {
    public static Stream<Element> streamOf(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return annotations.stream().map(roundEnv::getElementsAnnotatedWith).flatMap(Collection::stream);
    }

    public static TypeMirror extractResultType(Supplier<Class<?>> type) {
        try {
            type.get();
            throw new RuntimeException("Expecting exception to be raised");
        }
        catch (MirroredTypeException ex) {
            return ex.getTypeMirror();
        }
    }

    public static List<? extends TypeMirror> extractResultTypes(Supplier<Class<?>[]> types) {
        try {
            types.get();
            throw new RuntimeException("Expecting exception to be raised");
        }
        catch (MirroredTypesException ex) {
            return ex.getTypeMirrors();
        }
    }

    public static boolean isAssignableFrom(TypeMirror from, TypeMirror to) {
        TypeMirror current;
        TypeMirror typeMirror = current = from.getKind().equals((Object)TypeKind.TYPEVAR) ? ((TypeVariable)from).getUpperBound() : from;
        while (current instanceof DeclaredType && !Processors.isCompatible(to, current)) {
            current = ((DeclaredType)current).getEnclosingType();
        }
        return Processors.isCompatible(to, current);
    }

    private static boolean isCompatible(TypeMirror to, TypeMirror current) {
        if (to instanceof DeclaredType && current instanceof DeclaredType) {
            return current.toString().contains(to.toString());
        }
        return to.equals(current);
    }

    public static TypeElement getTypeElement(ProcessingEnvironment env, Class<?> type) {
        return env.getElementUtils().getTypeElement(type.getName());
    }

    private Processors() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

