/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.design;

import internal.nbbrd.design.proc.Elements2;
import internal.nbbrd.design.proc.ExecutableRules;
import internal.nbbrd.design.proc.Processing;
import internal.nbbrd.design.proc.Processors;
import internal.nbbrd.design.proc.Rule;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import nbbrd.design.BuilderPattern;

@SupportedAnnotationTypes(value={"nbbrd.design.BuilderPattern"})
public final class BuilderPatternProcessor
extends AbstractProcessor {
    private static final Rule<TypeElement> HAS_BUILD_METHOD = Rule.of(BuilderPatternProcessor::hasBuildMethod, "Cannot find build method in '%s'");
    private static final Rule<TypeElement> IS_BUILDER_PATTERN = Rule.on(TypeElement.class).and(HAS_BUILD_METHOD);

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return Processing.of(IS_BUILDER_PATTERN).process(annotations, roundEnv, this.processingEnv);
    }

    private static boolean hasBuildMethod(ProcessingEnvironment env, TypeElement type) {
        Rule<ExecutableElement> isBuildMethod = BuilderPatternProcessor.getIsBuildMethodRule(type.getAnnotation(BuilderPattern.class));
        return Elements2.methodsIn(type).anyMatch(isBuildMethod.asPredicate(env));
    }

    private static Rule<ExecutableElement> getIsBuildMethodRule(BuilderPattern annotation) {
        return Rule.on(ExecutableElement.class).and(Rule.isNamed(annotation.buildMethodName())).and(ExecutableRules.hasNoParameter()).and(Rule.of(method -> Processors.isAssignableFrom(method.getReturnType(), Processors.extractResultType(() -> ((BuilderPattern)annotation).value())), ""));
    }
}

