/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.design;

import internal.nbbrd.design.com.squareup.javapoet.ClassName;
import internal.nbbrd.design.com.squareup.javapoet.TypeName;
import internal.nbbrd.design.proc.Elements2;
import internal.nbbrd.design.proc.ExecutableRules;
import internal.nbbrd.design.proc.Processing;
import internal.nbbrd.design.proc.Processors;
import internal.nbbrd.design.proc.Rule;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import lombok.Generated;
import nbbrd.design.RepresentableAs;
import nbbrd.design.RepresentableAsInt;
import nbbrd.design.RepresentableAsString;
import nbbrd.design.StringValue;
import org.checkerframework.checker.nullness.qual.NonNull;

@SupportedAnnotationTypes(value={"nbbrd.design.StringValue", "nbbrd.design.RepresentableAs", "nbbrd.design.RepresentableAsInt", "nbbrd.design.RepresentableAsString"})
public final class RepresentableProcessor
extends AbstractProcessor {
    private static final Rule<TypeElement> IS_STRING_VALUE = RepresentableRule.builder(StringValue.class).parseType(o -> CharSequence.class).parseMethodName(StringValue::parseMethodName).formatType(o -> String.class).formatMethodName(StringValue::formatMethodName).build();
    private static final Rule<TypeElement> IS_INT = RepresentableRule.builder(RepresentableAsInt.class).parseType(o -> Integer.TYPE).parseMethodName(RepresentableAsInt::parseMethodName).formatType(o -> Integer.TYPE).formatMethodName(RepresentableAsInt::formatMethodName).build();
    private static final Rule<TypeElement> IS_STRING = RepresentableRule.builder(RepresentableAsString.class).parseType(o -> CharSequence.class).parseMethodName(RepresentableAsString::parseMethodName).formatType(o -> String.class).formatMethodName(RepresentableAsString::formatMethodName).build();
    private static final Rule<TypeElement> IS_TYPE = RepresentableRule.builder(RepresentableAs.class).parseType(RepresentableAs::value).parseMethodName(RepresentableAs::parseMethodName).formatType(RepresentableAs::value).formatMethodName(RepresentableAs::formatMethodName).build();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return Processing.of(IS_STRING_VALUE, IS_INT, IS_STRING, IS_TYPE).process(annotations, roundEnv, this.processingEnv);
    }

    public static final class RepresentableRule<A extends Annotation>
    implements Rule<TypeElement> {
        private final Class<A> annotationType;
        private final Function<A, Class<?>> parseType;
        private final Function<A, Class<?>> formatType;
        private final Function<A, String> parseMethodName;
        private final Function<A, String> formatMethodName;
        private final Rule<TypeElement> isRepresentableRule = Rule.on(TypeElement.class).and(this::hasParseMethod).and(this::hasFormatMethod);

        public static <A extends Annotation> Builder<A> builder(Class<A> annotationType) {
            return new Builder<A>().annotationType(annotationType);
        }

        private boolean isNullOrEmpty(String name) {
            return name == null || name.isEmpty();
        }

        private TypeMirror getTypeMirror(ProcessingEnvironment env, A annotation, Function<A, Class<?>> extractor) {
            try {
                Class<?> result = extractor.apply(annotation);
                return Processors.getTypeMirror(env, result);
            }
            catch (MirroredTypeException ex) {
                return ex.getTypeMirror();
            }
        }

        private String getParseMethodName(A annotation) {
            String result = this.parseMethodName.apply(annotation);
            return this.isNullOrEmpty(result) ? "parse" : result;
        }

        private String hasParseMethod(ProcessingEnvironment env, TypeElement type) {
            A annotation = type.getAnnotation(this.annotationType);
            String methodName = this.getParseMethodName(annotation);
            List methods = Elements2.methodsIn(type).filter(Rule.isNamed(methodName).asPredicate(env)).collect(Collectors.toList());
            Rule<ExecutableElement> isParseMethod = this.getIsParseMethod(this.getTypeMirror(env, annotation, this.parseType));
            switch (methods.size()) {
                case 1: {
                    return isParseMethod.check(env, (ExecutableElement)methods.get(0));
                }
            }
            return String.format("'%s' must have a parser", type);
        }

        private Rule<ExecutableElement> getIsParseMethod(TypeMirror parseType) {
            return Rule.on(ExecutableElement.class).and(Rule.is(Modifier.PUBLIC)).and(Rule.is(Modifier.STATIC)).and(ExecutableRules.returnsEnclosing()).and(ExecutableRules.hasParametersThat3(Rule.is3(parseType))).and(ExecutableRules.hasNoCheckedException());
        }

        private String getFormatMethodName(TypeMirror type, A annotation) {
            String result = this.formatMethodName.apply(annotation);
            if (!this.isNullOrEmpty(result)) {
                return result;
            }
            TypeName typeName = TypeName.get(type);
            return "to" + (typeName instanceof ClassName ? ((ClassName)typeName).simpleName() : typeName.toString());
        }

        private String hasFormatMethod(ProcessingEnvironment env, TypeElement type) {
            A annotation = type.getAnnotation(this.annotationType);
            TypeMirror formatTypeMirror = this.getTypeMirror(env, annotation, this.formatType);
            String methodName = this.getFormatMethodName(formatTypeMirror, annotation);
            List methods = Elements2.methodsIn(type).filter(Rule.isNamed(methodName).asPredicate(env)).collect(Collectors.toList());
            Rule<ExecutableElement> isFormatMethod = this.getIsFormatMethod(formatTypeMirror);
            switch (methods.size()) {
                case 1: {
                    return isFormatMethod.check(env, (ExecutableElement)methods.get(0));
                }
            }
            return String.format("'%s' must have a formatter", type);
        }

        private Rule<ExecutableElement> getIsFormatMethod(TypeMirror formatType) {
            return Rule.on(ExecutableElement.class).and(Rule.is(Modifier.PUBLIC)).and(Rule.isNot(Modifier.STATIC)).and(ExecutableRules.returnsTypeThat2(Rule.is3(formatType))).and(ExecutableRules.hasNoParameter()).and(ExecutableRules.hasNoCheckedException());
        }

        @Override
        public String check(ProcessingEnvironment env, TypeElement element) {
            return Elements2.hasAnnotation(element, this.annotationType) ? this.isRepresentableRule.check(env, element) : NO_ERROR;
        }

        @Generated
        RepresentableRule(Class<A> annotationType, Function<A, Class<?>> parseType, Function<A, Class<?>> formatType, Function<A, String> parseMethodName, Function<A, String> formatMethodName) {
            this.annotationType = annotationType;
            this.parseType = parseType;
            this.formatType = formatType;
            this.parseMethodName = parseMethodName;
            this.formatMethodName = formatMethodName;
        }

        @Generated
        public static class Builder<A extends Annotation> {
            @Generated
            private Class<A> annotationType;
            @Generated
            private Function<A, Class<?>> parseType;
            @Generated
            private Function<A, Class<?>> formatType;
            @Generated
            private Function<A, String> parseMethodName;
            @Generated
            private Function<A, String> formatMethodName;

            @Generated
            Builder() {
            }

            @Generated
            public @NonNull Builder<A> annotationType(Class<A> annotationType) {
                this.annotationType = annotationType;
                return this;
            }

            @Generated
            public @NonNull Builder<A> parseType(Function<A, Class<?>> parseType) {
                this.parseType = parseType;
                return this;
            }

            @Generated
            public @NonNull Builder<A> formatType(Function<A, Class<?>> formatType) {
                this.formatType = formatType;
                return this;
            }

            @Generated
            public @NonNull Builder<A> parseMethodName(Function<A, String> parseMethodName) {
                this.parseMethodName = parseMethodName;
                return this;
            }

            @Generated
            public @NonNull Builder<A> formatMethodName(Function<A, String> formatMethodName) {
                this.formatMethodName = formatMethodName;
                return this;
            }

            @Generated
            public @NonNull RepresentableRule<A> build() {
                return new RepresentableRule<A>(this.annotationType, this.parseType, this.formatType, this.parseMethodName, this.formatMethodName);
            }

            @Generated
            public @NonNull String toString() {
                return "RepresentableProcessor.RepresentableRule.Builder(annotationType=" + this.annotationType + ", parseType=" + this.parseType + ", formatType=" + this.formatType + ", parseMethodName=" + this.parseMethodName + ", formatMethodName=" + this.formatMethodName + ")";
            }
        }
    }
}

