/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.design;

import internal.nbbrd.design.proc.Processing;
import internal.nbbrd.design.proc.Processors;
import internal.nbbrd.design.proc.Rule;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import nbbrd.design.SealedType;

@SupportedAnnotationTypes(value={"nbbrd.design.SealedType"})
public class SealedTypeProcessor
extends AbstractProcessor {
    private static final Rule<TypeElement> HAS_SUBCLASSES = Rule.of(SealedTypeProcessor::hasSubclasses, "'%s' must have subclasses");
    private static final Rule<TypeElement> IS_SEALED_TYPE = Rule.on(TypeElement.class).and(Rule.isNot(Modifier.FINAL)).and(Rule.is(ElementKind.INTERFACE).or(Rule.is(ElementKind.CLASS).and(Rule.is(Modifier.ABSTRACT)))).and(HAS_SUBCLASSES);

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return Processing.of(IS_SEALED_TYPE).process(annotations, roundEnv, this.processingEnv);
    }

    private static boolean hasSubclasses(ProcessingEnvironment env, TypeElement type) {
        Types types = env.getTypeUtils();
        return Processors.extractResultTypes(() -> ((SealedType)type.getAnnotation(SealedType.class)).value()).stream().allMatch(subclass -> types.isAssignable((TypeMirror)subclass, types.erasure(type.asType())));
    }
}

