/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.design.proc;

import internal.nbbrd.design.proc.Processors;
import internal.nbbrd.design.proc.Rule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import lombok.Generated;
import nbbrd.design.SkipProcessing;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Processing<T extends Element> {
    private final List<Rule<? super T>> checks;

    public static <X extends Element> Processing<X> of(Rule<X> rule) {
        return Processing.builder().check(rule).build();
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, ProcessingEnvironment env) {
        if (roundEnv.processingOver()) {
            return false;
        }
        Processors.streamOf(annotations, roundEnv).map(element -> element).filter(element -> !this.isSkipRequired((Element)element, env)).forEach(element -> this.checkAll(element, env));
        return true;
    }

    private void checkAll(T element, ProcessingEnvironment env) {
        this.checks.forEach(check -> {
            String result = check.check(env, element);
            if (result != null) {
                env.getMessager().printMessage(Diagnostic.Kind.ERROR, result, (Element)element);
            }
        });
    }

    private boolean isSkipRequired(Element element, ProcessingEnvironment env) {
        SkipProcessing skip = element.getAnnotation(SkipProcessing.class);
        if (skip != null) {
            env.getMessager().printMessage(Diagnostic.Kind.WARNING, "Processing skipped on '" + element + "'; reason: '" + skip.reason() + "'", element);
            return true;
        }
        return false;
    }

    @Generated
    Processing(List<Rule<? super T>> checks) {
        this.checks = checks;
    }

    @Generated
    public static <T extends Element> @NonNull Builder<T> builder() {
        return new Builder();
    }

    @Generated
    public static class Builder<T extends Element> {
        @Generated
        private ArrayList<Rule<? super T>> checks;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder<T> check(Rule<? super T> check) {
            if (this.checks == null) {
                this.checks = new ArrayList();
            }
            this.checks.add(check);
            return this;
        }

        @Generated
        public @NonNull Builder<T> checks(@NonNull Collection<? extends Rule<? super T>> checks) {
            if (checks == null) {
                throw new NullPointerException("checks cannot be null");
            }
            if (this.checks == null) {
                this.checks = new ArrayList();
            }
            this.checks.addAll(checks);
            return this;
        }

        @Generated
        public @NonNull Builder<T> clearChecks() {
            if (this.checks != null) {
                this.checks.clear();
            }
            return this;
        }

        @Generated
        public @NonNull Processing<T> build() {
            List checks;
            switch (this.checks == null ? 0 : this.checks.size()) {
                case 0: {
                    checks = Collections.emptyList();
                    break;
                }
                case 1: {
                    checks = Collections.singletonList(this.checks.get(0));
                    break;
                }
                default: {
                    checks = Collections.unmodifiableList(new ArrayList<Rule<? super T>>(this.checks));
                }
            }
            return new Processing(checks);
        }

        @Generated
        public @NonNull String toString() {
            return "Processing.Builder(checks=" + this.checks + ")";
        }
    }
}

