/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.design.proc;

import internal.nbbrd.design.proc.Elements2;
import internal.nbbrd.design.proc.Processors;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

@FunctionalInterface
public interface Rule<T> {
    public static final String NO_ERROR = null;

    public String check(ProcessingEnvironment var1, T var2);

    default public boolean isValid(ProcessingEnvironment env, T element) {
        return this.check(env, element) == null;
    }

    default public Rule<T> or(Rule<? super T> other) {
        return (env, e) -> {
            String first = this.check(env, e);
            if (Objects.equals(first, NO_ERROR)) {
                return NO_ERROR;
            }
            String second = other.check(env, e);
            if (Objects.equals(second, NO_ERROR)) {
                return NO_ERROR;
            }
            return first + " or " + second;
        };
    }

    default public Rule<T> and(Rule<? super T> other) {
        return (env, e) -> {
            String result = this.check(env, e);
            return !Objects.equals(result, NO_ERROR) ? result : other.check(env, e);
        };
    }

    default public Predicate<T> asPredicate(ProcessingEnvironment env) {
        return element -> this.isValid(env, element);
    }

    public static <T extends Element> Rule<T> on(Class<T> ignore) {
        return (env, e) -> NO_ERROR;
    }

    public static <T extends Element> Rule<T> of(Predicate<? super T> condition, String formattedMessage) {
        return (env, e) -> !condition.test(e) ? String.format(Locale.ROOT, formattedMessage, e) : NO_ERROR;
    }

    public static <T> Rule<T> of(BiPredicate<ProcessingEnvironment, ? super T> condition, String formattedMessage) {
        return (env, e) -> !condition.test(env, (Object)e) ? String.format(Locale.ROOT, formattedMessage, e) : NO_ERROR;
    }

    public static <T> Rule<T> ifThenElse(BiPredicate<ProcessingEnvironment, ? super T> condition, Rule<T> thenRule, Rule<T> elseRule) {
        return (env, e) -> condition.test(env, (Object)e) ? thenRule.check(env, e) : elseRule.check(env, e);
    }

    public static <T extends Element> Rule<T> is(Modifier modifier) {
        return Rule.of((? super T e) -> Elements2.is(e, modifier), "'%s' must be " + (Object)((Object)modifier));
    }

    public static <T extends Element> Rule<T> isNot(Modifier modifier) {
        return Rule.of((? super T e) -> !Elements2.is(e, modifier), "'%s' must not be " + (Object)((Object)modifier));
    }

    public static <T extends Element> Rule<T> is(ElementKind kind) {
        return Rule.of((? super T e) -> Elements2.is(e, kind), "'%s' must be " + (Object)((Object)kind));
    }

    public static <T extends Element> Rule<T> isNamed(String name) {
        return Rule.of((? super T e) -> Elements2.isNamed(e, name), "'%s' must be named " + name);
    }

    public static <T extends Element> Rule<T> is(Element expected) {
        return Rule.of((ProcessingEnvironment env, ? super T e) -> env.getTypeUtils().isSameType(e.asType(), expected.asType()), "'%s' must be the type " + expected);
    }

    public static <T extends Element> Rule<T> is(Class<?> expected) {
        return Rule.of((ProcessingEnvironment env, ? super T e) -> env.getTypeUtils().isSameType(e.asType(), Processors.getTypeMirror(env, expected)), "'%s' must be the type " + expected);
    }

    public static <T extends TypeMirror> Rule<T> is2(Class<?> expected) {
        return Rule.of((ProcessingEnvironment env, ? super T e) -> env.getTypeUtils().isSameType((TypeMirror)e, Processors.getTypeMirror(env, expected)), "'%s' must be the type " + expected);
    }

    public static <T extends TypeMirror> Rule<T> is3(TypeMirror expected) {
        return Rule.of((ProcessingEnvironment env, ? super T e) -> env.getTypeUtils().isSameType((TypeMirror)e, expected), "'%s' must be the type " + expected);
    }
}

