/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.design;

import internal.nbbrd.design.proc.Elements2;
import internal.nbbrd.design.proc.Processing;
import internal.nbbrd.design.proc.Processors;
import internal.nbbrd.design.proc.Rule;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import nbbrd.design.DecoratorPattern;

@SupportedAnnotationTypes(value={"nbbrd.design.DecoratorPattern"})
public final class DecoratorPatternProcessor
extends AbstractProcessor {
    private static final Rule<TypeElement> IS_DECORATOR_PATTERN = Rule.on(TypeElement.class).and(Rule.is(ElementKind.CLASS)).and(Rule.of(DecoratorPatternProcessor::isExtendingDecoratedType, "'%s' doesn't extend a class")).and(Rule.of(DecoratorPatternProcessor::hasConstructorWithDecoratedType, "'%s' doesn't have a constructor with the decorated type"));

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return Processing.of(IS_DECORATOR_PATTERN).process(annotations, roundEnv, this.processingEnv);
    }

    private static boolean isExtendingDecoratedType(ProcessingEnvironment env, TypeElement type) {
        return DecoratorPatternProcessor.getDecoratedType(env, type).filter(decoratedType -> DecoratorPatternProcessor.isExtendingDecoratedType(env, type, decoratedType)).isPresent();
    }

    private static boolean isExtendingDecoratedType(ProcessingEnvironment env, TypeElement type, TypeMirror decoratedType) {
        return env.getTypeUtils().isAssignable(type.getSuperclass(), decoratedType) || type.getInterfaces().stream().anyMatch(x -> env.getTypeUtils().isAssignable((TypeMirror)x, decoratedType));
    }

    private static boolean hasConstructorWithDecoratedType(ProcessingEnvironment env, TypeElement type) {
        return DecoratorPatternProcessor.getDecoratedType(env, type).filter(decoratedType -> DecoratorPatternProcessor.hasConstructorWithDecoratedType(env, type, decoratedType)).isPresent();
    }

    private static boolean hasConstructorWithDecoratedType(ProcessingEnvironment env, TypeElement type, TypeMirror decoratedType) {
        return Elements2.constructorsIn(type).flatMap(method -> method.getParameters().stream()).anyMatch(var -> env.getTypeUtils().isSameType(decoratedType, var.asType()));
    }

    private static boolean isNullType(ProcessingEnvironment env, TypeMirror expected) {
        return env.getTypeUtils().isSameType(Processors.getTypeMirror(env, Void.class), expected);
    }

    private static boolean isDirectSuperClass(TypeMirror found) {
        return (!(found instanceof NoType) || found.getKind() != TypeKind.NONE) && !found.toString().equals("java.lang.Object");
    }

    private static Optional<TypeMirror> inferDecoratedType(TypeElement type) {
        TypeMirror superclass = type.getSuperclass();
        List<? extends TypeMirror> parents = type.getInterfaces();
        return DecoratorPatternProcessor.isDirectSuperClass(superclass) && parents.isEmpty() ? Optional.of(superclass) : (!DecoratorPatternProcessor.isDirectSuperClass(superclass) && parents.size() == 1 ? Optional.of(parents.get(0)) : Optional.empty());
    }

    private static Optional<TypeMirror> getDecoratedType(ProcessingEnvironment env, TypeElement type) {
        TypeMirror result = Processors.extractResultType(() -> ((DecoratorPattern)type.getAnnotation(DecoratorPattern.class)).value());
        return DecoratorPatternProcessor.isNullType(env, result) ? DecoratorPatternProcessor.inferDecoratedType(type) : Optional.of(result);
    }
}

