/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.design;

import internal.nbbrd.design.proc.Elements2;
import internal.nbbrd.design.proc.Processing;
import internal.nbbrd.design.proc.Rule;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@SupportedAnnotationTypes(value={"nbbrd.design.DirectImpl"})
public final class DirectImplProcessor
extends AbstractProcessor {
    private static final Rule<TypeElement> IS_DIRECT_IMPL = Rule.on(TypeElement.class).and(Rule.is(Modifier.FINAL)).and(Rule.it(DirectImplProcessor::doesNotExtendClass, "'%s' may not extend another class")).and(Rule.it(DirectImplProcessor::doesNotContainPublicVars, "'%s' may not contain public vars")).and(Rule.it(DirectImplProcessor::extendsAtLeastOneInterface, "'%s' must extend at least one interface"));

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return Processing.of(IS_DIRECT_IMPL).process(annotations, roundEnv, this.processingEnv);
    }

    private static boolean extendsAtLeastOneInterface(TypeElement type) {
        return !type.getInterfaces().isEmpty();
    }

    private static boolean doesNotExtendClass(TypeElement type) {
        return type.getSuperclass().toString().equals(Object.class.getName());
    }

    private static boolean doesNotContainPublicVars(TypeElement type) {
        return Elements2.fieldsIn(type).noneMatch(DirectImplProcessor::isVariableNotStaticButPublic);
    }

    private static boolean isVariableNotStaticButPublic(VariableElement e) {
        Set<Modifier> modifiers = e.getModifiers();
        return !modifiers.contains((Object)Modifier.STATIC) && modifiers.contains((Object)Modifier.PUBLIC);
    }
}

