/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.design;

import internal.nbbrd.design.proc.Elements2;
import internal.nbbrd.design.proc.Processing;
import internal.nbbrd.design.proc.Rule;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"nbbrd.design.Trait"})
public final class TraitProcessor
extends AbstractProcessor {
    private static final Rule<TypeElement> IS_TRAIT = Rule.on(TypeElement.class).and(Rule.is(ElementKind.INTERFACE)).and(Rule.isNamedTesting(TraitProcessor::isValidName, "must end with 'ble' or start with 'Has'")).and(Rule.it(TraitProcessor::hasAtLeastOneMethod, "'%s' must have at least one method"));

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return Processing.of(IS_TRAIT).process(annotations, roundEnv, this.processingEnv);
    }

    private static boolean hasAtLeastOneMethod(TypeElement type) {
        return Elements2.methodsIn(type).findAny().isPresent();
    }

    static boolean isValidName(String name) {
        return name.endsWith("ble") || name.startsWith("Has");
    }
}

