/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.design;

import internal.nbbrd.design.proc.Processing;
import internal.nbbrd.design.proc.Rule;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@SupportedAnnotationTypes(value={"nbbrd.design.ClassNameConstant"})
public final class ClassNameConstantProcessor
extends AbstractProcessor {
    private static final Rule<VariableElement> IS_CLASS_NAME_CONSTANT = Rule.on(VariableElement.class).and(Rule.is(Modifier.STATIC)).and(Rule.is(Modifier.FINAL)).and(Rule.is(String.class)).and(Rule.it(ClassNameConstantProcessor::hasClassName, "'%s' should represent the full name of its enclosing class"));

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return Processing.of(IS_CLASS_NAME_CONSTANT).process(annotations, roundEnv, this.processingEnv);
    }

    private static boolean hasClassName(VariableElement field) {
        Object constantValue = field.getConstantValue();
        return constantValue instanceof String && field.getEnclosingElement().toString().equals(constantValue);
    }
}

