/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.design;

import internal.nbbrd.design.proc.Elements2;
import internal.nbbrd.design.proc.Processing;
import internal.nbbrd.design.proc.Rule;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import nbbrd.design.Immutable;

@SupportedAnnotationTypes(value={"nbbrd.design.Immutable"})
public final class ImmutableProcessor
extends AbstractProcessor {
    private static final Rule<TypeElement> IS_IMMUTABLE = Rule.on(TypeElement.class).and(Rule.is(Modifier.FINAL)).and(Rule.it(ImmutableProcessor::hasFieldsFinalOrLazy, "Fields of '%s' must be final or lazy")).and(Rule.it(ImmutableProcessor::hasFieldsPrivate, "Fields of '%s' must be private")).and(Rule.it(ImmutableProcessor::hasLazyFieldIfLazy, "'%s' must have at least one lazy field"));

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return Processing.of(IS_IMMUTABLE).process(annotations, roundEnv, this.processingEnv);
    }

    private static boolean hasFieldsFinalOrLazy(TypeElement type) {
        boolean lazy = type.getAnnotation(Immutable.class).lazy();
        return ImmutableProcessor.getNonStaticFields(type).allMatch(field -> field.getModifiers().contains((Object)Modifier.FINAL) || lazy && field.getModifiers().contains((Object)Modifier.VOLATILE));
    }

    private static boolean hasFieldsPrivate(TypeElement type) {
        return ImmutableProcessor.getNonStaticFields(type).allMatch(field -> field.getModifiers().contains((Object)Modifier.PRIVATE));
    }

    private static boolean hasLazyFieldIfLazy(TypeElement type) {
        boolean lazy = type.getAnnotation(Immutable.class).lazy();
        return !lazy || ImmutableProcessor.getNonStaticFields(type).anyMatch(field -> field.getModifiers().contains((Object)Modifier.VOLATILE));
    }

    private static Stream<VariableElement> getNonStaticFields(TypeElement type) {
        return Elements2.fieldsIn(type).filter(field -> !field.getModifiers().contains((Object)Modifier.STATIC));
    }
}

