/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.design;

import internal.nbbrd.design.proc.ExecutableRules;
import internal.nbbrd.design.proc.Processing;
import internal.nbbrd.design.proc.Processors;
import internal.nbbrd.design.proc.Rule;
import internal.nbbrd.design.proc.TypeRules;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import nbbrd.design.StaticFactoryMethod;

@SupportedAnnotationTypes(value={"nbbrd.design.StaticFactoryMethod"})
public class StaticFactoryMethodProcessor
extends AbstractProcessor {
    private static final Rule<ExecutableElement> ENCLOSED = ExecutableRules.returnsEnclosing().and(ExecutableRules.returnsTypeThat(TypeRules.hasNoPublicConstructor()));
    private static final Rule<ExecutableElement> EXTERNAL = ExecutableRules.returns(StaticFactoryMethodProcessor::getAnnotationValue);
    private static final Rule<ExecutableElement> IS_STATIC_FACTORY_METHOD = Rule.on(ExecutableElement.class).and(Rule.is(Modifier.STATIC)).and(Rule.is(Modifier.PUBLIC)).and(Rule.ifThenElse(StaticFactoryMethodProcessor::isEnclosedType, ENCLOSED, EXTERNAL));

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return Processing.of(IS_STATIC_FACTORY_METHOD).process(annotations, roundEnv, this.processingEnv);
    }

    private static TypeMirror getAnnotationValue(ExecutableElement x) {
        return Processors.extractResultType(() -> ((StaticFactoryMethod)x.getAnnotation(StaticFactoryMethod.class)).value());
    }

    private static boolean isEnclosedType(ProcessingEnvironment env, ExecutableElement x) {
        TypeMirror expected = Processors.getTypeMirror(env, Void.class);
        TypeMirror found = StaticFactoryMethodProcessor.getAnnotationValue(x);
        return env.getTypeUtils().isSameType(expected, found);
    }
}

