/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.xml;

import internal.io.text.LegacyFiles;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.Resource;
import nbbrd.io.WrappedIOException;
import nbbrd.io.function.IORunnable;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.xml.Xml;

public final class Stax {
    private static final Closeable NOTHING_TO_CLOSE = IORunnable.noOp().asCloseable();

    public static void preventXXE(@org.checkerframework.checker.nullness.qual.NonNull XMLInputFactory factory) {
        Stax.setFeature(factory, "javax.xml.stream.supportDTD", false);
        Stax.setFeature(factory, "javax.xml.stream.isSupportingExternalEntities", false);
    }

    private static XMLInputFactory getInputEngine(IOSupplier<? extends XMLInputFactory> factory, boolean ignoreXXE) throws IOException {
        XMLInputFactory result = (XMLInputFactory)factory.getWithIO();
        if (!ignoreXXE) {
            Stax.preventXXE(result);
        }
        return result;
    }

    private static <T, INPUT> T doParse(FlowHandler<INPUT, T> handler, INPUT input, Closeable onClose) throws IOException {
        try {
            return handler.parse(input, onClose);
        }
        catch (XMLStreamException ex) {
            Resource.ensureClosed((Throwable)ex, (Closeable)onClose);
            throw Stax.toIOException(ex);
        }
        catch (IOException | Error | RuntimeException ex) {
            Resource.ensureClosed((Throwable)ex, (Closeable)onClose);
            throw ex;
        }
    }

    private static <T, OUTPUT> void doFormat(OutputHandler2<OUTPUT, T> handler2, T value, OUTPUT output, Charset encoding, Closeable onClose) throws IOException {
        try {
            handler2.format(value, output, encoding);
        }
        catch (Exception ex) {
            Resource.ensureClosed((Throwable)ex, (Closeable)onClose);
            throw Stax.toIOException(ex);
        }
        catch (Error ex) {
            Resource.ensureClosed((Throwable)ex, (Closeable)onClose);
            throw ex;
        }
    }

    private static void close(XRunnable first) throws IOException {
        try {
            first.run();
        }
        catch (XMLStreamException ex) {
            throw Stax.toIOException(ex);
        }
    }

    private static void closeBoth(XRunnable first, Closeable second) throws IOException {
        try {
            first.run();
        }
        catch (XMLStreamException ex) {
            Resource.ensureClosed((Throwable)ex, (Closeable)second);
            throw Stax.toIOException(ex);
        }
        catch (Error | RuntimeException ex) {
            Resource.ensureClosed((Throwable)ex, (Closeable)second);
            throw ex;
        }
        second.close();
    }

    private static void setFeature(XMLInputFactory factory, String feature, boolean value) {
        if (factory.isPropertySupported(feature) && (Boolean)factory.getProperty(feature) != value) {
            factory.setProperty(feature, value);
        }
    }

    private static IOException toIOException(Exception ex) {
        if (ex instanceof XMLStreamException) {
            return Stax.toIOException((XMLStreamException)ex);
        }
        if (ex instanceof IOException) {
            return (IOException)ex;
        }
        return WrappedIOException.wrap((Throwable)ex);
    }

    public static IOException toIOException(XMLStreamException ex) {
        if (Stax.isEOF(ex)) {
            return new EOFException(Objects.toString(Stax.getFile(ex)));
        }
        return WrappedIOException.wrap((Throwable)ex);
    }

    private static boolean isEOF(XMLStreamException ex) {
        return ex.getLocation() != null && ex.getMessage() != null && ex.getMessage().contains("end of file");
    }

    private static File getFile(XMLStreamException ex) {
        String result = ex.getLocation().getSystemId();
        return result != null && result.startsWith("file:/") ? LegacyFiles.fromSystemId((String)result) : null;
    }

    @Generated
    private Stax() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    private static interface XFunction<T, R> {
        public R apply(T var1) throws XMLStreamException;
    }

    @FunctionalInterface
    private static interface XRunnable {
        public void run() throws XMLStreamException;
    }

    public static final class EventFormatter<T>
    implements Xml.Formatter<T> {
        @NonNull
        private final OutputHandler2<XMLEventWriter, T> handler2;
        @NonNull
        private final IOSupplier<? extends XMLOutputFactory> factory;
        @NonNull
        private final Charset encoding;

        @Deprecated
        public static <T> @org.checkerframework.checker.nullness.qual.NonNull EventFormatter<T> valueOf(@org.checkerframework.checker.nullness.qual.NonNull OutputHandler<XMLEventWriter, T> handler) {
            return EventFormatter.of(handler.withEncoding());
        }

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull EventFormatter<T> of(@org.checkerframework.checker.nullness.qual.NonNull OutputHandler2<XMLEventWriter, T> handler2) {
            return EventFormatter.builder().handler2(handler2).build();
        }

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Builder<T> builder() {
            return new Builder().factory((IOSupplier<XMLOutputFactory>)((IOSupplier)XMLOutputFactory::newFactory)).encoding(StandardCharsets.UTF_8);
        }

        @Deprecated
        public EventFormatter<T> withHandler(OutputHandler<XMLEventWriter, T> handler) {
            return this.withHandler2(handler.withEncoding());
        }

        @Override
        public boolean isFormatted() {
            return false;
        }

        @Override
        public Charset getDefaultEncoding() {
            return this.encoding;
        }

        public void formatFile(T value, File target) throws IOException {
            Objects.requireNonNull(value, "value");
            LegacyFiles.checkTarget((File)target);
            try (OutputStream resource = LegacyFiles.newOutputStream((File)target);){
                this.format(value, o -> o.createXMLEventWriter(resource, this.getDefaultEncoding().name()), this.getDefaultEncoding());
            }
        }

        public void formatWriter(T value, IOSupplier<? extends Writer> target) throws IOException {
            Objects.requireNonNull(value, "value");
            Objects.requireNonNull(target, "target");
            try (Writer resource = (Writer)LegacyFiles.checkResource((Closeable)((Writer)target.getWithIO()), (String)"Missing Writer");){
                this.format(value, o -> o.createXMLEventWriter(resource), this.getDefaultEncoding());
            }
        }

        public void formatStream(T value, IOSupplier<? extends OutputStream> target) throws IOException {
            Objects.requireNonNull(value, "value");
            Objects.requireNonNull(target, "target");
            try (OutputStream resource = (OutputStream)LegacyFiles.checkResource((Closeable)((OutputStream)target.getWithIO()), (String)"Missing OutputStream");){
                this.format(value, o -> o.createXMLEventWriter(resource, this.getDefaultEncoding().name()), this.getDefaultEncoding());
            }
        }

        public void formatWriter(T value, Writer resource) throws IOException {
            Objects.requireNonNull(value, "value");
            Objects.requireNonNull(resource, "resource");
            this.format(value, o -> o.createXMLEventWriter(resource), this.getDefaultEncoding());
        }

        public void formatStream(T value, OutputStream resource) throws IOException {
            Objects.requireNonNull(value, "value");
            Objects.requireNonNull(resource, "resource");
            this.format(value, o -> o.createXMLEventWriter(resource, this.getDefaultEncoding().name()), this.getDefaultEncoding());
        }

        public void formatStream(T value, OutputStream resource, Charset encoding) throws IOException {
            Objects.requireNonNull(value, "value");
            Objects.requireNonNull(resource, "resource");
            Objects.requireNonNull(encoding, "encoding");
            this.format(value, o -> o.createXMLEventWriter(resource, encoding.name()), encoding);
        }

        private void format(T value, XFunction<XMLOutputFactory, XMLEventWriter> supplier, Charset realEncoding) throws IOException {
            try {
                XMLEventWriter output = supplier.apply(this.getEngine());
                Stax.doFormat(this.handler2, value, output, realEncoding, () -> Stax.close(output::close));
                output.close();
            }
            catch (XMLStreamException ex) {
                throw Stax.toIOException(ex);
            }
        }

        private XMLOutputFactory getEngine() throws IOException {
            XMLOutputFactory result = (XMLOutputFactory)this.factory.getWithIO();
            return result;
        }

        @Generated
        EventFormatter(@NonNull OutputHandler2<XMLEventWriter, T> handler2, @NonNull IOSupplier<? extends XMLOutputFactory> factory, @NonNull Charset encoding) {
            if (handler2 == null) {
                throw new NullPointerException("handler2 is marked non-null but is null");
            }
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            this.handler2 = handler2;
            this.factory = factory;
            this.encoding = encoding;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> toBuilder() {
            return new Builder<T>().handler2(this.handler2).factory(this.factory).encoding(this.encoding);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull EventFormatter<T> withHandler2(@NonNull OutputHandler2<XMLEventWriter, T> handler2) {
            if (handler2 == null) {
                throw new NullPointerException("handler2 is marked non-null but is null");
            }
            return this.handler2 == handler2 ? this : new EventFormatter<T>(handler2, this.factory, this.encoding);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull EventFormatter<T> withFactory(@NonNull IOSupplier<? extends XMLOutputFactory> factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            return this.factory == factory ? this : new EventFormatter<T>(this.handler2, factory, this.encoding);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull EventFormatter<T> withEncoding(@NonNull Charset encoding) {
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            return this.encoding == encoding ? this : new EventFormatter<T>(this.handler2, this.factory, encoding);
        }

        public static final class Builder<T> {
            @Generated
            private OutputHandler2<XMLEventWriter, T> handler2;
            @Generated
            private IOSupplier<? extends XMLOutputFactory> factory;
            @Generated
            private Charset encoding;

            @Deprecated
            public Builder<T> handler(OutputHandler<XMLEventWriter, T> handler) {
                return this.handler2(handler.withEncoding());
            }

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> handler2(@NonNull OutputHandler2<XMLEventWriter, T> handler2) {
                if (handler2 == null) {
                    throw new NullPointerException("handler2 is marked non-null but is null");
                }
                this.handler2 = handler2;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> factory(@NonNull IOSupplier<? extends XMLOutputFactory> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked non-null but is null");
                }
                this.factory = factory;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> encoding(@NonNull Charset encoding) {
                if (encoding == null) {
                    throw new NullPointerException("encoding is marked non-null but is null");
                }
                this.encoding = encoding;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull EventFormatter<T> build() {
                return new EventFormatter<T>(this.handler2, this.factory, this.encoding);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "Stax.EventFormatter.Builder(handler2=" + this.handler2 + ", factory=" + this.factory + ", encoding=" + this.encoding + ")";
            }
        }
    }

    public static final class StreamFormatter<T>
    implements Xml.Formatter<T> {
        @NonNull
        private final OutputHandler2<XMLStreamWriter, T> handler2;
        @NonNull
        private final IOSupplier<? extends XMLOutputFactory> factory;
        @NonNull
        private final Charset encoding;

        @Deprecated
        public static <T> @org.checkerframework.checker.nullness.qual.NonNull StreamFormatter<T> valueOf(@org.checkerframework.checker.nullness.qual.NonNull OutputHandler<XMLStreamWriter, T> handler) {
            return StreamFormatter.of(handler.withEncoding());
        }

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull StreamFormatter<T> of(@org.checkerframework.checker.nullness.qual.NonNull OutputHandler2<XMLStreamWriter, T> handler2) {
            return StreamFormatter.builder().handler2(handler2).build();
        }

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Builder<T> builder() {
            return new Builder().factory((IOSupplier<XMLOutputFactory>)((IOSupplier)XMLOutputFactory::newFactory)).encoding(StandardCharsets.UTF_8);
        }

        @Deprecated
        public StreamFormatter<T> withHandler(OutputHandler<XMLStreamWriter, T> handler) {
            return this.withHandler2(handler.withEncoding());
        }

        @Override
        public boolean isFormatted() {
            return false;
        }

        @Override
        public Charset getDefaultEncoding() {
            return this.encoding;
        }

        public void formatFile(T value, File target) throws IOException {
            Objects.requireNonNull(value, "value");
            LegacyFiles.checkTarget((File)target);
            try (OutputStream resource = LegacyFiles.newOutputStream((File)target);){
                this.format(value, o -> o.createXMLStreamWriter(resource, this.getDefaultEncoding().name()), this.getDefaultEncoding());
            }
        }

        public void formatWriter(T value, IOSupplier<? extends Writer> target) throws IOException {
            Objects.requireNonNull(value, "value");
            Objects.requireNonNull(target, "target");
            try (Writer resource = (Writer)LegacyFiles.checkResource((Closeable)((Writer)target.getWithIO()), (String)"Missing Writer");){
                this.format(value, o -> o.createXMLStreamWriter(resource), this.getDefaultEncoding());
            }
        }

        public void formatStream(T value, IOSupplier<? extends OutputStream> target) throws IOException {
            Objects.requireNonNull(value, "value");
            Objects.requireNonNull(target, "target");
            try (OutputStream resource = (OutputStream)LegacyFiles.checkResource((Closeable)((OutputStream)target.getWithIO()), (String)"Missing OutputStream");){
                this.format(value, o -> o.createXMLStreamWriter(resource, this.getDefaultEncoding().name()), this.getDefaultEncoding());
            }
        }

        public void formatWriter(T value, Writer resource) throws IOException {
            Objects.requireNonNull(value, "value");
            Objects.requireNonNull(resource, "resource");
            this.format(value, o -> o.createXMLStreamWriter(resource), this.getDefaultEncoding());
        }

        public void formatStream(T value, OutputStream resource) throws IOException {
            Objects.requireNonNull(value);
            Objects.requireNonNull(resource, "resource");
            this.format(value, o -> o.createXMLStreamWriter(resource, this.getDefaultEncoding().name()), this.getDefaultEncoding());
        }

        public void formatStream(T value, OutputStream resource, Charset encoding) throws IOException {
            Objects.requireNonNull(value, "value");
            Objects.requireNonNull(resource, "resource");
            Objects.requireNonNull(encoding, "encoding");
            this.format(value, o -> o.createXMLStreamWriter(resource, encoding.name()), encoding);
        }

        private void format(T value, XFunction<XMLOutputFactory, XMLStreamWriter> supplier, Charset realEncoding) throws IOException {
            try {
                XMLStreamWriter output = supplier.apply(this.getEngine());
                Stax.doFormat(this.handler2, value, output, realEncoding, () -> Stax.close(output::close));
                output.close();
            }
            catch (XMLStreamException ex) {
                throw Stax.toIOException(ex);
            }
        }

        private XMLOutputFactory getEngine() throws IOException {
            XMLOutputFactory result = (XMLOutputFactory)this.factory.getWithIO();
            return result;
        }

        @Generated
        StreamFormatter(@NonNull OutputHandler2<XMLStreamWriter, T> handler2, @NonNull IOSupplier<? extends XMLOutputFactory> factory, @NonNull Charset encoding) {
            if (handler2 == null) {
                throw new NullPointerException("handler2 is marked non-null but is null");
            }
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            this.handler2 = handler2;
            this.factory = factory;
            this.encoding = encoding;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> toBuilder() {
            return new Builder<T>().handler2(this.handler2).factory(this.factory).encoding(this.encoding);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull StreamFormatter<T> withHandler2(@NonNull OutputHandler2<XMLStreamWriter, T> handler2) {
            if (handler2 == null) {
                throw new NullPointerException("handler2 is marked non-null but is null");
            }
            return this.handler2 == handler2 ? this : new StreamFormatter<T>(handler2, this.factory, this.encoding);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull StreamFormatter<T> withFactory(@NonNull IOSupplier<? extends XMLOutputFactory> factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            return this.factory == factory ? this : new StreamFormatter<T>(this.handler2, factory, this.encoding);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull StreamFormatter<T> withEncoding(@NonNull Charset encoding) {
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            return this.encoding == encoding ? this : new StreamFormatter<T>(this.handler2, this.factory, encoding);
        }

        public static final class Builder<T> {
            @Generated
            private OutputHandler2<XMLStreamWriter, T> handler2;
            @Generated
            private IOSupplier<? extends XMLOutputFactory> factory;
            @Generated
            private Charset encoding;

            @Deprecated
            public Builder<T> handler(OutputHandler<XMLStreamWriter, T> handler) {
                return this.handler2(handler.withEncoding());
            }

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> handler2(@NonNull OutputHandler2<XMLStreamWriter, T> handler2) {
                if (handler2 == null) {
                    throw new NullPointerException("handler2 is marked non-null but is null");
                }
                this.handler2 = handler2;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> factory(@NonNull IOSupplier<? extends XMLOutputFactory> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked non-null but is null");
                }
                this.factory = factory;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> encoding(@NonNull Charset encoding) {
                if (encoding == null) {
                    throw new NullPointerException("encoding is marked non-null but is null");
                }
                this.encoding = encoding;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull StreamFormatter<T> build() {
                return new StreamFormatter<T>(this.handler2, this.factory, this.encoding);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "Stax.StreamFormatter.Builder(handler2=" + this.handler2 + ", factory=" + this.factory + ", encoding=" + this.encoding + ")";
            }
        }
    }

    public static final class EventParser<T>
    implements Xml.Parser<T> {
        @NonNull
        private final FlowHandler<XMLEventReader, T> handler;
        @NonNull
        private final IOSupplier<? extends XMLInputFactory> factory;
        private final boolean ignoreXXE;

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull EventParser<T> flowOf(@org.checkerframework.checker.nullness.qual.NonNull FlowHandler<XMLEventReader, T> handler) {
            return EventParser.builder().flow(handler).build();
        }

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull EventParser<T> valueOf(@org.checkerframework.checker.nullness.qual.NonNull ValueHandler<XMLEventReader, T> handler) {
            return EventParser.flowOf(handler.asFlow());
        }

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Builder<T> builder() {
            return new Builder().factory((IOSupplier<XMLInputFactory>)((IOSupplier)XMLInputFactory::newFactory)).ignoreXXE(false);
        }

        public T parseFile(File source) throws IOException {
            LegacyFiles.checkSource((File)source);
            InputStream resource = LegacyFiles.newInputStream((File)source);
            return this.parse((XMLInputFactory o) -> o.createXMLEventReader(LegacyFiles.toSystemId((File)source), resource), (Closeable)resource);
        }

        public T parseFile(File source, Charset encoding) throws IOException {
            LegacyFiles.checkSource((File)source);
            Objects.requireNonNull(encoding, "encoding");
            InputStream resource = LegacyFiles.newInputStream((File)source);
            return this.parse((XMLInputFactory o) -> o.createXMLEventReader(LegacyFiles.toSystemId((File)source), resource), (Closeable)resource);
        }

        public T parseReader(IOSupplier<? extends Reader> source) throws IOException {
            Objects.requireNonNull(source, "source");
            Reader resource = (Reader)LegacyFiles.checkResource((Closeable)((Reader)source.getWithIO()), (String)"Missing Reader");
            return this.parse((XMLInputFactory o) -> o.createXMLEventReader(resource), (Closeable)resource);
        }

        public T parseStream(IOSupplier<? extends InputStream> source) throws IOException {
            Objects.requireNonNull(source, "source");
            InputStream resource = (InputStream)LegacyFiles.checkResource((Closeable)((InputStream)source.getWithIO()), (String)"Missing InputStream");
            return this.parse((XMLInputFactory o) -> o.createXMLEventReader(resource), (Closeable)resource);
        }

        public T parseReader(Reader resource) throws IOException {
            Objects.requireNonNull(resource, "resource");
            return this.parse((XMLInputFactory o) -> o.createXMLEventReader(resource), NOTHING_TO_CLOSE);
        }

        public T parseStream(InputStream resource) throws IOException {
            Objects.requireNonNull(resource, "resource");
            return this.parse((XMLInputFactory o) -> o.createXMLEventReader(resource), NOTHING_TO_CLOSE);
        }

        public T parseStream(InputStream resource, Charset encoding) throws IOException {
            Objects.requireNonNull(resource, "resource");
            Objects.requireNonNull(encoding, "encoding");
            return this.parse((XMLInputFactory o) -> o.createXMLEventReader(resource, encoding.name()), NOTHING_TO_CLOSE);
        }

        private T parse(XMLEventReader input, Closeable onClose) throws IOException {
            return (T)Stax.doParse(this.handler, input, onClose);
        }

        private T parse(XFunction<XMLInputFactory, XMLEventReader> supplier, Closeable onClose) throws IOException {
            try {
                XMLEventReader input = supplier.apply(Stax.getInputEngine((IOSupplier<? extends XMLInputFactory>)this.factory, this.ignoreXXE));
                return this.parse(input, () -> Stax.closeBoth(input::close, onClose));
            }
            catch (XMLStreamException ex) {
                Resource.ensureClosed((Throwable)ex, (Closeable)onClose);
                throw Stax.toIOException(ex);
            }
            catch (IOException | Error | RuntimeException ex) {
                Resource.ensureClosed((Throwable)ex, (Closeable)onClose);
                throw ex;
            }
        }

        @Generated
        EventParser(@NonNull FlowHandler<XMLEventReader, T> handler, @NonNull IOSupplier<? extends XMLInputFactory> factory, boolean ignoreXXE) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            this.handler = handler;
            this.factory = factory;
            this.ignoreXXE = ignoreXXE;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> toBuilder() {
            return new Builder<T>().handler(this.handler).factory(this.factory).ignoreXXE(this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull EventParser<T> withHandler(@NonNull FlowHandler<XMLEventReader, T> handler) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            return this.handler == handler ? this : new EventParser<T>(handler, this.factory, this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull EventParser<T> withFactory(@NonNull IOSupplier<? extends XMLInputFactory> factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            return this.factory == factory ? this : new EventParser<T>(this.handler, factory, this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull EventParser<T> withIgnoreXXE(boolean ignoreXXE) {
            return this.ignoreXXE == ignoreXXE ? this : new EventParser<T>(this.handler, this.factory, ignoreXXE);
        }

        @Override
        @Generated
        public boolean isIgnoreXXE() {
            return this.ignoreXXE;
        }

        public static final class Builder<T> {
            @Generated
            private FlowHandler<XMLEventReader, T> handler;
            @Generated
            private IOSupplier<? extends XMLInputFactory> factory;
            @Generated
            private boolean ignoreXXE;

            public Builder<T> flow(FlowHandler<XMLEventReader, T> handler) {
                return this.handler(handler);
            }

            public Builder<T> value(ValueHandler<XMLEventReader, T> handler) {
                return this.handler(handler.asFlow());
            }

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> handler(@NonNull FlowHandler<XMLEventReader, T> handler) {
                if (handler == null) {
                    throw new NullPointerException("handler is marked non-null but is null");
                }
                this.handler = handler;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> factory(@NonNull IOSupplier<? extends XMLInputFactory> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked non-null but is null");
                }
                this.factory = factory;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> ignoreXXE(boolean ignoreXXE) {
                this.ignoreXXE = ignoreXXE;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull EventParser<T> build() {
                return new EventParser<T>(this.handler, this.factory, this.ignoreXXE);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "Stax.EventParser.Builder(handler=" + this.handler + ", factory=" + this.factory + ", ignoreXXE=" + this.ignoreXXE + ")";
            }
        }
    }

    public static final class StreamParser<T>
    implements Xml.Parser<T> {
        @NonNull
        private final FlowHandler<XMLStreamReader, T> handler;
        @NonNull
        private final IOSupplier<? extends XMLInputFactory> factory;
        private final boolean ignoreXXE;

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull StreamParser<T> flowOf(@org.checkerframework.checker.nullness.qual.NonNull FlowHandler<XMLStreamReader, T> handler) {
            return StreamParser.builder().flow(handler).build();
        }

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull StreamParser<T> valueOf(@org.checkerframework.checker.nullness.qual.NonNull ValueHandler<XMLStreamReader, T> handler) {
            return StreamParser.flowOf(handler.asFlow());
        }

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Builder<T> builder() {
            return new Builder().factory((IOSupplier<XMLInputFactory>)((IOSupplier)XMLInputFactory::newFactory)).ignoreXXE(false);
        }

        public T parseFile(File source) throws IOException {
            LegacyFiles.checkSource((File)source);
            InputStream resource = LegacyFiles.newInputStream((File)source);
            return this.parse((XMLInputFactory o) -> o.createXMLStreamReader(LegacyFiles.toSystemId((File)source), resource), (Closeable)resource);
        }

        public T parseFile(File source, Charset encoding) throws IOException {
            LegacyFiles.checkSource((File)source);
            Objects.requireNonNull(encoding, "encoding");
            InputStream resource = LegacyFiles.newInputStream((File)source);
            return this.parse((XMLInputFactory o) -> o.createXMLStreamReader(LegacyFiles.toSystemId((File)source), resource), (Closeable)resource);
        }

        public T parseReader(IOSupplier<? extends Reader> source) throws IOException {
            Objects.requireNonNull(source, "source");
            Reader resource = (Reader)LegacyFiles.checkResource((Closeable)((Reader)source.getWithIO()), (String)"Missing Reader");
            return this.parse((XMLInputFactory o) -> o.createXMLStreamReader(resource), (Closeable)resource);
        }

        public T parseStream(IOSupplier<? extends InputStream> source) throws IOException {
            Objects.requireNonNull(source, "source");
            InputStream resource = (InputStream)LegacyFiles.checkResource((Closeable)((InputStream)source.getWithIO()), (String)"Missing InputStream");
            return this.parse((XMLInputFactory o) -> o.createXMLStreamReader(resource), (Closeable)resource);
        }

        public T parseReader(Reader resource) throws IOException {
            Objects.requireNonNull(resource, "resource");
            return this.parse((XMLInputFactory o) -> o.createXMLStreamReader(resource), NOTHING_TO_CLOSE);
        }

        public T parseStream(InputStream resource) throws IOException {
            Objects.requireNonNull(resource, "resource");
            return this.parse((XMLInputFactory o) -> o.createXMLStreamReader(resource), NOTHING_TO_CLOSE);
        }

        public T parseStream(InputStream resource, Charset encoding) throws IOException {
            Objects.requireNonNull(resource, "resource");
            Objects.requireNonNull(encoding, "encoding");
            return this.parse((XMLInputFactory o) -> o.createXMLStreamReader(resource, encoding.name()), NOTHING_TO_CLOSE);
        }

        public @org.checkerframework.checker.nullness.qual.NonNull T parse(@org.checkerframework.checker.nullness.qual.NonNull XMLStreamReader input, @org.checkerframework.checker.nullness.qual.NonNull Closeable onClose) throws IOException {
            return (T)Stax.doParse(this.handler, input, onClose);
        }

        private T parse(XFunction<XMLInputFactory, XMLStreamReader> supplier, Closeable onClose) throws IOException {
            try {
                XMLStreamReader input = supplier.apply(Stax.getInputEngine((IOSupplier<? extends XMLInputFactory>)this.factory, this.ignoreXXE));
                return this.parse(input, () -> Stax.closeBoth(input::close, onClose));
            }
            catch (XMLStreamException ex) {
                Resource.ensureClosed((Throwable)ex, (Closeable)onClose);
                throw Stax.toIOException(ex);
            }
            catch (IOException | Error | RuntimeException ex) {
                Resource.ensureClosed((Throwable)ex, (Closeable)onClose);
                throw ex;
            }
        }

        @Generated
        StreamParser(@NonNull FlowHandler<XMLStreamReader, T> handler, @NonNull IOSupplier<? extends XMLInputFactory> factory, boolean ignoreXXE) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            this.handler = handler;
            this.factory = factory;
            this.ignoreXXE = ignoreXXE;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> toBuilder() {
            return new Builder<T>().handler(this.handler).factory(this.factory).ignoreXXE(this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull StreamParser<T> withHandler(@NonNull FlowHandler<XMLStreamReader, T> handler) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            return this.handler == handler ? this : new StreamParser<T>(handler, this.factory, this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull StreamParser<T> withFactory(@NonNull IOSupplier<? extends XMLInputFactory> factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            return this.factory == factory ? this : new StreamParser<T>(this.handler, factory, this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull StreamParser<T> withIgnoreXXE(boolean ignoreXXE) {
            return this.ignoreXXE == ignoreXXE ? this : new StreamParser<T>(this.handler, this.factory, ignoreXXE);
        }

        @Override
        @Generated
        public boolean isIgnoreXXE() {
            return this.ignoreXXE;
        }

        public static final class Builder<T> {
            @Generated
            private FlowHandler<XMLStreamReader, T> handler;
            @Generated
            private IOSupplier<? extends XMLInputFactory> factory;
            @Generated
            private boolean ignoreXXE;

            public Builder<T> flow(FlowHandler<XMLStreamReader, T> handler) {
                return this.handler(handler);
            }

            public Builder<T> value(ValueHandler<XMLStreamReader, T> handler) {
                return this.handler(handler.asFlow());
            }

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> handler(@NonNull FlowHandler<XMLStreamReader, T> handler) {
                if (handler == null) {
                    throw new NullPointerException("handler is marked non-null but is null");
                }
                this.handler = handler;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> factory(@NonNull IOSupplier<? extends XMLInputFactory> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked non-null but is null");
                }
                this.factory = factory;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> ignoreXXE(boolean ignoreXXE) {
                this.ignoreXXE = ignoreXXE;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull StreamParser<T> build() {
                return new StreamParser<T>(this.handler, this.factory, this.ignoreXXE);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "Stax.StreamParser.Builder(handler=" + this.handler + ", factory=" + this.factory + ", ignoreXXE=" + this.ignoreXXE + ")";
            }
        }
    }

    @FunctionalInterface
    public static interface OutputHandler2<O, T> {
        public void format(@org.checkerframework.checker.nullness.qual.NonNull T var1, @org.checkerframework.checker.nullness.qual.NonNull O var2, @org.checkerframework.checker.nullness.qual.NonNull Charset var3) throws Exception;
    }

    @Deprecated
    @FunctionalInterface
    public static interface OutputHandler<O, T> {
        public void format(@org.checkerframework.checker.nullness.qual.NonNull T var1, @org.checkerframework.checker.nullness.qual.NonNull O var2) throws Exception;

        default public OutputHandler2<O, T> withEncoding() {
            return (t, o, e) -> this.format(t, o);
        }
    }

    @FunctionalInterface
    public static interface ValueHandler<I, T> {
        public @org.checkerframework.checker.nullness.qual.NonNull T parse(@org.checkerframework.checker.nullness.qual.NonNull I var1) throws XMLStreamException;

        default public @org.checkerframework.checker.nullness.qual.NonNull FlowHandler<I, T> asFlow() {
            return (input, onClose) -> {
                try (Closeable c = onClose;){
                    T t = this.parse(input);
                    return t;
                }
            };
        }
    }

    @FunctionalInterface
    public static interface FlowHandler<I, T> {
        public @org.checkerframework.checker.nullness.qual.NonNull T parse(@org.checkerframework.checker.nullness.qual.NonNull I var1, @org.checkerframework.checker.nullness.qual.NonNull Closeable var2) throws IOException, XMLStreamException;

        public static <I, T> @org.checkerframework.checker.nullness.qual.NonNull FlowHandler<I, T> of(@org.checkerframework.checker.nullness.qual.NonNull ValueHandler<I, T> handler) {
            return handler.asFlow();
        }
    }
}

